/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.spring;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DeprecatedPropertyBean
extends AbstractInitializableComponent
implements ApplicationContextAware {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger((String)"DEPRECATED");
    @Nonnull
    private ApplicationContext applicationContext;
    @Nonnull
    private Map<String, String> deprecatedProperties = Collections.emptyMap();
    @Nonnull
    @NonnullElements
    private Collection<String> deadProperties = Collections.emptyList();

    public void setDeprecatedProperties(@Nonnull Map<String, String> map) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(map, (String)"Property map cannot be null");
        this.deprecatedProperties = new HashMap<String, String>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.deprecatedProperties.put(StringSupport.trimOrNull((String)entry.getKey()), StringSupport.trimOrNull((String)entry.getValue()));
        }
    }

    public void setDeadProperties(@Nonnull @NonnullElements Collection<String> properties) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(properties, (String)"Property collection cannot be null");
        this.deadProperties = StringSupport.normalizeStringCollection(properties);
    }

    public void setApplicationContext(ApplicationContext context) {
        this.applicationContext = (ApplicationContext)Constraint.isNotNull((Object)context, (String)"ApplicationContext cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        for (Map.Entry<String, String> entry : this.deprecatedProperties.entrySet()) {
            if (!this.applicationContext.getEnvironment().containsProperty(entry.getKey())) continue;
            DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.PROPERTY, (String)entry.getKey(), null, (String)entry.getValue());
        }
        for (String name : this.deadProperties) {
            if (!this.applicationContext.getEnvironment().containsProperty(name)) continue;
            this.log.warn("property '{}' is no longer supported", (Object)name);
        }
    }
}

