/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.spring;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.StringUtils;

public class IdPPropertiesApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    @Nonnull
    @NotEmpty
    public static final String IDP_HOME_PROPERTY = "idp.home";
    @Nonnull
    @NotEmpty
    public static final String IDP_ADDITIONAL_PROPERTY = "idp.additionalProperties";
    @Nonnull
    public static final String IDP_PROPERTIES = "/conf/idp.properties";
    @Nonnull
    public static final String[] SEARCH_LOCATIONS = new String[]{System.getProperty("idp.home", "/opt/shibboleth-idp")};
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(IdPPropertiesApplicationContextInitializer.class);

    public void initialize(@Nonnull ConfigurableApplicationContext applicationContext) {
        this.log.debug("Initializing application context '{}'", (Object)applicationContext);
        this.log.debug("Attempting to find '{}' at well known locations '{}'", (Object)this.getSearchTarget(), (Object)this.getSearchLocations());
        for (String searchLocation : this.getSearchLocations()) {
            String searchPath = searchLocation + this.getSearchTarget();
            this.log.debug("Attempting to find resource '{}'", (Object)searchPath);
            Resource resource = applicationContext.getResource(searchPath);
            if (!resource.exists()) continue;
            this.log.debug("Found resource '{}' at search path '{}'", (Object)resource, (Object)searchPath);
            Properties properties = this.loadProperties(null, resource);
            if (properties == null) {
                this.log.warn("Unable to load properties from resource '{}'", (Object)resource);
                return;
            }
            if ("classpath:".equals(searchLocation) || resource instanceof ClassPathResource) {
                this.setIdPHomeProperty(searchLocation, properties);
            } else {
                String searchLocationAbsolutePath = Paths.get(searchLocation, new String[0]).toAbsolutePath().toString();
                this.setIdPHomeProperty(searchLocationAbsolutePath, properties);
            }
            String additionalSources = properties.getProperty(IDP_ADDITIONAL_PROPERTY);
            if (additionalSources != null) {
                String[] sources;
                for (String source : sources = additionalSources.split(",")) {
                    String trimmedSource = StringSupport.trimOrNull((String)source);
                    if (trimmedSource == null) continue;
                    this.log.debug("Attempting to load properties from resource '{}'", (Object)trimmedSource);
                    String pathifiedSource = searchLocation + trimmedSource;
                    Resource additionalResource = applicationContext.getResource(pathifiedSource);
                    if (additionalResource.exists()) {
                        this.log.debug("Found resource '{}' at search path '{}'", (Object)additionalResource, (Object)pathifiedSource);
                        if (this.loadProperties(properties, additionalResource) != null) continue;
                        this.log.warn("Unable to load properties from resource '{}'", (Object)additionalResource);
                        continue;
                    }
                    this.log.warn("Unable to find resource '{}'", (Object)additionalResource);
                }
            }
            this.logProperties(properties);
            PropertiesPropertySource propertySource = new PropertiesPropertySource(resource.toString(), properties);
            applicationContext.getEnvironment().getPropertySources().addLast((PropertySource)propertySource);
            return;
        }
        this.log.warn("Unable to find '{}' at well known locations '{}'", (Object)this.getSearchTarget(), (Object)this.getSearchLocations());
    }

    @Nonnull
    public String getSearchTarget() {
        return IDP_PROPERTIES;
    }

    @Nonnull
    public String[] getSearchLocations() {
        return SEARCH_LOCATIONS;
    }

    @Nullable
    public Properties loadProperties(@Nullable Properties sink, @Nonnull Resource resource) {
        Constraint.isNotNull((Object)resource, (String)"Resource cannot be null");
        try {
            Properties properties = sink != null ? sink : new Properties();
            PropertiesLoaderUtils.fillProperties((Properties)properties, (Resource)resource);
            return properties;
        }
        catch (IOException e) {
            this.log.warn("Unable to load properties from resource '{}'", (Object)resource, (Object)e);
            return null;
        }
    }

    public void logProperties(@Nonnull Properties properties) {
        if (this.log.isDebugEnabled()) {
            Pattern pattern = Pattern.compile("password|credential", 2);
            for (String name : new TreeSet<String>(properties.stringPropertyNames())) {
                String value = pattern.matcher(name).find() ? "<suppressed>" : properties.get(name);
                this.log.debug("Loaded property '{}'='{}'", (Object)name, (Object)value);
            }
        }
    }

    @Nonnull
    public String normalizePath(@Nonnull String path) {
        Constraint.isNotNull((Object)path, (String)"Path cannot be null");
        String normalized = StringUtils.cleanPath((String)path);
        this.log.debug("Normalized path '{}' to '{}'", (Object)path, (Object)normalized);
        return normalized;
    }

    public void setIdPHomeProperty(@Nonnull String path, @Nonnull Properties properties) {
        Constraint.isNotNull((Object)path, (String)"Path cannot be null");
        Constraint.isNotNull((Object)properties, (String)"Properties cannot be null");
        if (properties.getProperty(IDP_HOME_PROPERTY) != null) {
            this.log.debug("Will not set '{}' property because it is already set.", (Object)IDP_HOME_PROPERTY);
            return;
        }
        if (System.getProperty(IDP_HOME_PROPERTY) != null) {
            this.log.debug("Will not set '{}' property because it is already set as a system property '{}'", (Object)IDP_HOME_PROPERTY, (Object)System.getProperty(IDP_HOME_PROPERTY));
            return;
        }
        String normalizedPath = this.normalizePath(path);
        this.log.debug("Setting '{}' property to '{}'", (Object)IDP_HOME_PROPERTY, (Object)normalizedPath);
        properties.setProperty(IDP_HOME_PROPERTY, normalizedPath);
    }
}

