/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cli;

import com.beust.jcommander.Parameter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cli.AbstractCommandLineArguments;

public class ResolverTestArguments
extends AbstractCommandLineArguments {
    @Parameter(names={"-r", "--requester"}, required=true, description="Relying party identity")
    @Nullable
    private String requester;
    @Parameter(names={"-n", "--principal"}, required=true, description="Subject principal name")
    @Nullable
    private String principal;
    @Parameter(names={"-i", "--acsIndex"}, description="AttributeConsumingService index")
    @Nullable
    private Integer index;
    @Parameter(names={"--protocol"}, description="Show results with a custom protocol encoding")
    @Nullable
    private String protocol;
    @Parameter(names={"--saml1"}, description="Show results with SAML 1.1 encoding")
    private boolean saml1;
    @Parameter(names={"--saml2"}, description="Show results with SAML 2.0 encoding")
    private boolean saml2;
    @Parameter(names={"--configDir"}, description="This option is obsolete", hidden=true)
    @Nullable
    private String dummy1;
    @Parameter(names={"--springExt"}, description="This option is obsolete", hidden=true)
    @Nullable
    private String dummy2;
    @Parameter(names={"--issuer"}, description="This option is obsolete", hidden=true)
    @Nullable
    private String dummy3;
    @Parameter(names={"--authnMethod"}, description="This option is obsolete", hidden=true)
    @Nullable
    private String dummy4;

    @Override
    public void validate() {
        if (this.saml1 ? this.saml2 || this.protocol != null : (this.saml2 ? this.saml1 || this.protocol != null : this.protocol != null && (this.saml1 || this.saml2))) {
            throw new IllegalArgumentException("The saml1, saml2, and protocol options are mutually exclusive");
        }
    }

    @Override
    protected StringBuilder doBuildURL(@Nonnull StringBuilder builder) {
        if (this.getPath() == null) {
            builder.append("/idp/profile/admin/resolvertest");
        }
        if (builder.toString().contains("?")) {
            builder.append('&');
        } else {
            builder.append('?');
        }
        try {
            builder.append("requester=").append(URLEncoder.encode(this.requester, "UTF-8"));
            builder.append("&principal=").append(URLEncoder.encode(this.principal, "UTF-8"));
            if (this.index != null) {
                builder.append("&acsIndex").append(this.index.toString());
            }
            if (this.saml1) {
                builder.append("&saml1");
            } else if (this.saml2) {
                builder.append("&saml2");
            } else if (this.protocol != null) {
                builder.append("&protocol=").append(URLEncoder.encode(this.protocol, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return builder;
    }
}

