/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.lang.reflect.Constructor;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactoryRegistry;
import net.shibboleth.idp.authn.principal.PrincipalSupportingComponent;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.joda.time.DateTime;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;

public final class AuthenticationContext
extends BaseContext {
    @Positive
    private final long initiationInstant = System.currentTimeMillis();
    private boolean forceAuthn;
    private boolean isPassive;
    @Nullable
    private String hintedName;
    @Duration
    @NonNegative
    private long maxAge;
    @Nullable
    private Function<ProfileRequestContext, String> fixedEventLookupStrategy;
    @Nonnull
    @NonnullElements
    private final Map<String, AuthenticationFlowDescriptor> availableFlows = new HashMap<String, AuthenticationFlowDescriptor>();
    @Nonnull
    @NonnullElements
    private final Map<String, AuthenticationFlowDescriptor> potentialFlows = new LinkedHashMap<String, AuthenticationFlowDescriptor>();
    @Nonnull
    @NonnullElements
    private final Map<String, AuthenticationResult> activeResults = new HashMap<String, AuthenticationResult>();
    @Nonnull
    @NonnullElements
    private final Map<String, AuthenticationFlowDescriptor> intermediateFlows = new HashMap<String, AuthenticationFlowDescriptor>();
    @Nullable
    private PrincipalEvalPredicateFactoryRegistry evalRegistry;
    @Nullable
    private AuthenticationFlowDescriptor attemptedFlow;
    @Nullable
    private String signaledFlowId;
    @Nonnull
    private final Map<String, Object> stateMap = new HashMap<String, Object>();
    @Nullable
    private AuthenticationResult initialAuthenticationResult;
    @Nullable
    private AuthenticationResult authenticationResult;
    private boolean resultCacheable = true;
    @NonNegative
    private long completionInstant;

    @Positive
    public long getInitiationInstant() {
        return this.initiationInstant;
    }

    @Nonnull
    @NonnullElements
    @Live
    public Map<String, AuthenticationResult> getActiveResults() {
        return this.activeResults;
    }

    @Nonnull
    public AuthenticationContext setActiveResults(@Nonnull @NonnullElements Iterable<AuthenticationResult> results) {
        Constraint.isNotNull(results, (String)"AuthenticationResult collection cannot be null");
        this.activeResults.clear();
        for (AuthenticationResult result : results) {
            this.activeResults.put(result.getAuthenticationFlowId(), result);
        }
        return this;
    }

    @Nonnull
    @NonnullElements
    @Live
    public Map<String, AuthenticationFlowDescriptor> getAvailableFlows() {
        return this.availableFlows;
    }

    @Nonnull
    @NonnullElements
    @Live
    public Map<String, AuthenticationFlowDescriptor> getPotentialFlows() {
        return this.potentialFlows;
    }

    @Nonnull
    @NonnullElements
    @Live
    public Map<String, AuthenticationFlowDescriptor> getIntermediateFlows() {
        return this.intermediateFlows;
    }

    @Nonnull
    public PrincipalEvalPredicateFactoryRegistry getPrincipalEvalPredicateFactoryRegistry() {
        RequestedPrincipalContext rpCtx = (RequestedPrincipalContext)this.getSubcontext(RequestedPrincipalContext.class);
        if (rpCtx != null) {
            return rpCtx.getPrincipalEvalPredicateFactoryRegistry();
        }
        if (this.evalRegistry != null) {
            return this.evalRegistry;
        }
        return new PrincipalEvalPredicateFactoryRegistry();
    }

    @Nonnull
    public AuthenticationContext setPrincipalEvalPredicateFactoryRegistry(@Nullable PrincipalEvalPredicateFactoryRegistry registry) {
        this.evalRegistry = registry;
        RequestedPrincipalContext rpCtx = (RequestedPrincipalContext)this.getSubcontext(RequestedPrincipalContext.class);
        if (rpCtx != null) {
            rpCtx.setPrincipalEvalPredicateFactoryRegistry(registry);
        }
        return this;
    }

    public boolean isPassive() {
        return this.isPassive;
    }

    @Nonnull
    public AuthenticationContext setIsPassive(boolean passive) {
        this.isPassive = passive;
        return this;
    }

    public boolean isForceAuthn() {
        return this.forceAuthn;
    }

    @Nonnull
    public AuthenticationContext setForceAuthn(boolean force) {
        this.forceAuthn = force;
        return this;
    }

    @Nullable
    @NotEmpty
    public String getHintedName() {
        return this.hintedName;
    }

    @Nonnull
    public AuthenticationContext setHintedName(@Nullable String hint) {
        this.hintedName = StringSupport.trimOrNull((String)hint);
        return this;
    }

    @Duration
    @NonNegative
    public long getMaxAge() {
        return this.maxAge;
    }

    @Nonnull
    public AuthenticationContext setMaxAge(@Duration @NonNegative long age) {
        this.maxAge = Constraint.isGreaterThanOrEqual((long)0L, (long)age, (String)"MaxAge cannot be negative");
        return this;
    }

    @Nullable
    public Function<ProfileRequestContext, String> getFixedEventLookupStrategy() {
        return this.fixedEventLookupStrategy;
    }

    @Nonnull
    public AuthenticationContext setFixedEventLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.fixedEventLookupStrategy = strategy;
        return this;
    }

    @Nullable
    public AuthenticationFlowDescriptor getAttemptedFlow() {
        return this.attemptedFlow;
    }

    @Nonnull
    public AuthenticationContext setAttemptedFlow(@Nullable AuthenticationFlowDescriptor flow) {
        this.attemptedFlow = flow;
        return this;
    }

    @Nullable
    @NotEmpty
    public String getSignaledFlowId() {
        return this.signaledFlowId;
    }

    @Nonnull
    public AuthenticationContext setSignaledFlowId(@Nullable String id) {
        this.signaledFlowId = StringSupport.trimOrNull((String)id);
        return this;
    }

    @Nonnull
    @Live
    public Map<String, Object> getAuthenticationStateMap() {
        return this.stateMap;
    }

    @Nullable
    public AuthenticationResult getInitialAuthenticationResult() {
        return this.initialAuthenticationResult;
    }

    @Nonnull
    public AuthenticationContext setInitialAuthenticationResult(@Nullable AuthenticationResult result) {
        this.initialAuthenticationResult = result;
        return this;
    }

    @Nullable
    public AuthenticationResult getAuthenticationResult() {
        return this.authenticationResult;
    }

    @Nonnull
    public AuthenticationContext setAuthenticationResult(@Nullable AuthenticationResult result) {
        this.authenticationResult = result;
        return this;
    }

    public boolean isResultCacheable() {
        return this.resultCacheable;
    }

    public void setResultCacheable(boolean flag) {
        this.resultCacheable = flag;
    }

    @NonNegative
    public long getCompletionInstant() {
        return this.completionInstant;
    }

    @Nonnull
    public AuthenticationContext setCompletionInstant() {
        this.completionInstant = System.currentTimeMillis();
        return this;
    }

    public boolean isAcceptable(@Nonnull PrincipalSupportingComponent component) {
        RequestedPrincipalContext rpCtx = (RequestedPrincipalContext)this.getSubcontext(RequestedPrincipalContext.class);
        if (rpCtx != null) {
            return rpCtx.isAcceptable(component);
        }
        return true;
    }

    public boolean isAcceptable(@Nonnull @NonnullElements Collection<Principal> principals) {
        RequestedPrincipalContext rpCtx = (RequestedPrincipalContext)this.getSubcontext(RequestedPrincipalContext.class);
        if (rpCtx != null) {
            return rpCtx.isAcceptable(principals);
        }
        return true;
    }

    public <T extends Principal> boolean isAcceptable(@Nonnull T principal) {
        RequestedPrincipalContext rpCtx = (RequestedPrincipalContext)this.getSubcontext(RequestedPrincipalContext.class);
        if (rpCtx != null) {
            return rpCtx.isAcceptable(principal);
        }
        return true;
    }

    public boolean addRequestedPrincipalContext(@Nonnull @NotEmpty String operator, @Nonnull @NotEmpty String className, @Nonnull @NotEmpty String principal, boolean replace) throws Exception {
        return this.addRequestedPrincipalContext(operator, className, Collections.singletonList(principal), replace);
    }

    public boolean addRequestedPrincipalContext(@Nonnull @NotEmpty String operator, @Nonnull @NotEmpty String className, @Nonnull Collection<String> principals, boolean replace) throws Exception {
        Class<Principal> claz = Class.forName(className).asSubclass(Principal.class);
        Constructor<Principal> ctor = claz.getConstructor(String.class);
        ArrayList<Principal> prins = new ArrayList<Principal>(principals.size());
        for (String prin : Collections2.filter(principals, (Predicate)Predicates.notNull())) {
            prins.add(ctor.newInstance(prin));
        }
        return this.addRequestedPrincipalContext(operator, prins, replace);
    }

    public boolean addRequestedPrincipalContext(@Nonnull @NotEmpty String operator, @Nonnull Principal principal, boolean replace) {
        return this.addRequestedPrincipalContext(operator, Collections.singletonList(principal), replace);
    }

    public boolean addRequestedPrincipalContext(@Nonnull @NotEmpty String operator, @Nonnull @NonnullElements List<Principal> principals, boolean replace) {
        RequestedPrincipalContext rpCtx = (RequestedPrincipalContext)this.getSubcontext(RequestedPrincipalContext.class);
        if (rpCtx != null && !replace) {
            return false;
        }
        rpCtx = new RequestedPrincipalContext();
        rpCtx.setOperator(operator).setPrincipalEvalPredicateFactoryRegistry(this.evalRegistry).setRequestedPrincipals(principals);
        this.addSubcontext(rpCtx, true);
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("initiationInstant", (Object)new DateTime(this.initiationInstant)).add("isPassive", this.isPassive).add("forceAuthn", this.forceAuthn).add("hintedName", (Object)this.hintedName).add("maxAge", this.maxAge).add("potentialFlows", this.potentialFlows.keySet()).add("activeResults", this.activeResults.keySet()).add("attemptedFlow", (Object)this.attemptedFlow).add("signaledFlowId", (Object)this.signaledFlowId).add("authenticationStateMap", this.stateMap).add("resultCacheable", this.resultCacheable).add("initialAuthenticationResult", (Object)this.initialAuthenticationResult).add("authenticationResult", (Object)this.authenticationResult).add("completionInstant", (Object)new DateTime(this.completionInstant)).toString();
    }
}

