/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;

public class AuthenticationErrorContext
extends BaseContext {
    @Nonnull
    @NonnullElements
    private List<Exception> exceptions = new ArrayList<Exception>();
    private Collection<String> classifiedErrors = new HashSet<String>();

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public List<Exception> getExceptions() {
        return ImmutableList.copyOf(this.exceptions);
    }

    public void addException(@Nonnull Exception e) {
        Constraint.isNotNull((Object)e, (String)"Exception cannot be null");
        this.exceptions.add(e);
    }

    @Nonnull
    @NonnullElements
    @Live
    public Collection<String> getClassifiedErrors() {
        return this.classifiedErrors;
    }

    public boolean isClassifiedError(@Nonnull @NotEmpty String error) {
        return this.classifiedErrors.contains(error);
    }
}

