/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.AuthenticationErrorContext;
import net.shibboleth.idp.authn.context.AuthenticationWarningContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicate;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactory;
import net.shibboleth.idp.authn.principal.PrincipalSupportingComponent;
import net.shibboleth.idp.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractValidationAction<InboundMessageType, OutboundMessageType>
extends AbstractAuthenticationAction<InboundMessageType, OutboundMessageType>
implements PrincipalSupportingComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractValidationAction.class);
    @Nonnull
    private final Subject authenticatedSubject = new Subject();
    private boolean addDefaultPrincipals = true;
    private boolean clearErrorContext = true;
    @Nonnull
    @NonnullElements
    private Map<String, Collection<String>> classifiedMessages = Collections.emptyMap();
    @Nullable
    private Predicate<ProfileRequestContext> resultCachingPredicate;
    @Nullable
    private Function<ProfileRequestContext, String> requesterLookupStrategy = new RelyingPartyIdLookupFunction();
    @Nullable
    private Function<ProfileRequestContext, String> responderLookupStrategy = new ResponderIdLookupFunction();

    public boolean addDefaultPrincipals() {
        return this.addDefaultPrincipals;
    }

    public void setAddDefaultPrincipals(boolean flag) {
        this.addDefaultPrincipals = flag;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public Map<String, Collection<String>> getClassifiedErrors() {
        return ImmutableMap.copyOf(this.classifiedMessages);
    }

    public void setClassifiedMessages(@Nonnull @NonnullElements Map<String, Collection<String>> messages) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(messages, (String)"Map of classified messages cannot be null");
        this.classifiedMessages = new HashMap<String, Collection<String>>();
        for (Map.Entry<String, Collection<String>> entry : messages.entrySet()) {
            if (entry.getKey() == null || entry.getKey().isEmpty() || entry.getValue() == null || entry.getValue().isEmpty()) continue;
            this.classifiedMessages.put(entry.getKey(), (Collection<String>)ImmutableList.copyOf((Collection)Collections2.filter(entry.getValue(), (Predicate)Predicates.notNull())));
        }
    }

    @Nullable
    public Predicate<ProfileRequestContext> getResultCachingPredicate() {
        return this.resultCachingPredicate;
    }

    public void setResultCachingPredicate(@Nullable Predicate<ProfileRequestContext> predicate) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.resultCachingPredicate = predicate;
    }

    public void setRequesterLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requesterLookupStrategy = strategy;
    }

    public void setResponderLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.responderLookupStrategy = strategy;
    }

    @Override
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public <T extends Principal> Set<T> getSupportedPrincipals(@Nonnull Class<T> c) {
        return this.authenticatedSubject.getPrincipals(c);
    }

    public <T extends Principal> void setSupportedPrincipals(@Nullable @NonnullElements Collection<T> principals) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.authenticatedSubject.getPrincipals().clear();
        if (principals != null && !principals.isEmpty()) {
            this.addDefaultPrincipals = false;
            this.authenticatedSubject.getPrincipals().addAll(Collections2.filter(principals, (Predicate)Predicates.notNull()));
        } else {
            this.addDefaultPrincipals = true;
        }
    }

    @Nonnull
    protected Subject getSubject() {
        return this.authenticatedSubject;
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext<InboundMessageType, OutboundMessageType> profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        RequestedPrincipalContext rpCtx;
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        if (authenticationContext.getAttemptedFlow() == null) {
            this.log.info("{} No attempted flow within authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent(profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (this.clearErrorContext) {
            authenticationContext.removeSubcontext(AuthenticationErrorContext.class);
        }
        if ((rpCtx = (RequestedPrincipalContext)authenticationContext.getSubcontext(RequestedPrincipalContext.class)) != null && rpCtx.getOperator() != null && !this.authenticatedSubject.getPrincipals().isEmpty()) {
            this.log.debug("{} Request contains principal requirements, evaluating for compatibility", (Object)this.getLogPrefix());
            for (Principal p : rpCtx.getRequestedPrincipals()) {
                PrincipalEvalPredicateFactory factory = authenticationContext.getPrincipalEvalPredicateFactoryRegistry().lookup(p.getClass(), rpCtx.getOperator());
                if (factory != null) {
                    PrincipalEvalPredicate predicate = factory.getPredicate(p);
                    if (predicate.apply(this)) {
                        this.log.debug("{} Compatible with principal type '{}' and operator '{}'", new Object[]{this.getLogPrefix(), p.getClass(), rpCtx.getOperator()});
                        rpCtx.setMatchingPrincipal(predicate.getMatchingPrincipal());
                        return true;
                    }
                    this.log.debug("{} Not compatible with principal type '{}' and operator '{}'", new Object[]{this.getLogPrefix(), p.getClass(), rpCtx.getOperator()});
                    continue;
                }
                this.log.debug("{} No comparison logic registered for principal type '{}' and operator '{}'", new Object[]{this.getLogPrefix(), p.getClass(), rpCtx.getOperator()});
            }
            this.log.info("{} Skipping validator, not compatible with request's principal requirements", (Object)this.getLogPrefix());
            ActionSupport.buildEvent(profileRequestContext, (String)"RequestUnsupported");
            return false;
        }
        return true;
    }

    protected void buildAuthenticationResult(@Nonnull ProfileRequestContext<InboundMessageType, OutboundMessageType> profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (this.addDefaultPrincipals && authenticationContext.getAttemptedFlow() != null) {
            this.log.debug("{} Adding custom Principal(s) defined on underlying flow descriptor", (Object)this.getLogPrefix());
            this.authenticatedSubject.getPrincipals().addAll(authenticationContext.getAttemptedFlow().getSupportedPrincipals());
        }
        AuthenticationResult result = new AuthenticationResult(authenticationContext.getAttemptedFlow().getId(), this.populateSubject(this.authenticatedSubject));
        authenticationContext.setAuthenticationResult(result);
        if (authenticationContext.isResultCacheable() && this.resultCachingPredicate != null) {
            authenticationContext.setResultCacheable(this.resultCachingPredicate.apply(profileRequestContext));
            this.log.info("{} Predicate indicates authentication result {} be cacheable in a session", (Object)this.getLogPrefix(), (Object)(authenticationContext.isResultCacheable() ? "will" : "will not"));
        }
        SubjectCanonicalizationContext c14n = new SubjectCanonicalizationContext();
        c14n.setSubject(result.getSubject());
        if (this.requesterLookupStrategy != null) {
            c14n.setRequesterId((String)this.requesterLookupStrategy.apply(profileRequestContext));
        }
        if (this.responderLookupStrategy != null) {
            c14n.setResponderId((String)this.responderLookupStrategy.apply(profileRequestContext));
        }
        profileRequestContext.addSubcontext((BaseContext)c14n, true);
    }

    @Nonnull
    protected abstract Subject populateSubject(@Nonnull Subject var1);

    protected void handleError(@Nonnull ProfileRequestContext<InboundMessageType, OutboundMessageType> profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull Exception e, @Nonnull @NotEmpty String eventId) {
        AuthenticationErrorContext errorCtx = (AuthenticationErrorContext)authenticationContext.getSubcontext(AuthenticationErrorContext.class, true);
        errorCtx.addException(e);
        this.handleError(profileRequestContext, authenticationContext, e.getMessage(), eventId);
    }

    protected void handleError(@Nonnull ProfileRequestContext<InboundMessageType, OutboundMessageType> profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nullable String message, @Nonnull @NotEmpty String eventId) {
        boolean eventSet = false;
        if (!Strings.isNullOrEmpty((String)message)) {
            MessageChecker checker = new MessageChecker(message);
            for (Map.Entry<String, Collection<String>> entry : this.classifiedMessages.entrySet()) {
                if (!Iterables.any((Iterable)entry.getValue(), (Predicate)checker)) continue;
                ((AuthenticationErrorContext)authenticationContext.getSubcontext(AuthenticationErrorContext.class, true)).getClassifiedErrors().add(entry.getKey());
                if (eventSet) continue;
                eventSet = true;
                ActionSupport.buildEvent(profileRequestContext, (String)entry.getKey());
            }
        }
        if (!eventSet) {
            ActionSupport.buildEvent(profileRequestContext, (String)eventId);
        }
    }

    protected void handleWarning(@Nonnull ProfileRequestContext<InboundMessageType, OutboundMessageType> profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nullable String message, @Nonnull @NotEmpty String eventId) {
        boolean eventSet = false;
        if (!Strings.isNullOrEmpty((String)message)) {
            MessageChecker checker = new MessageChecker(message);
            for (Map.Entry<String, Collection<String>> entry : this.classifiedMessages.entrySet()) {
                if (!Iterables.any((Iterable)entry.getValue(), (Predicate)checker)) continue;
                ((AuthenticationWarningContext)authenticationContext.getSubcontext(AuthenticationWarningContext.class, true)).getClassifiedWarnings().add(entry.getKey());
                if (eventSet) continue;
                eventSet = true;
                ActionSupport.buildEvent(profileRequestContext, (String)entry.getKey());
            }
        }
        if (!eventSet) {
            ActionSupport.buildEvent(profileRequestContext, (String)eventId);
        }
    }

    private class MessageChecker
    implements Predicate<String> {
        @Nonnull
        @NotEmpty
        private final String s;

        public MessageChecker(String msg) {
            Constraint.isFalse((boolean)Strings.isNullOrEmpty((String)msg), (String)"Message cannot be null or empty");
            this.s = msg;
        }

        public boolean apply(String input) {
            return this.s.contains(input);
        }
    }
}

