/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AbstractValidationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.idp.authn.principal.PasswordPrincipal;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUsernamePasswordValidationAction
extends AbstractValidationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractUsernamePasswordValidationAction.class);
    private boolean savePasswordToCredentialSet;
    @Nullable
    private UsernamePasswordContext upContext;

    public boolean savePasswordToCredentialSet() {
        return this.savePasswordToCredentialSet;
    }

    public void setSavePasswordToCredentialSet(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.savePasswordToCredentialSet = flag;
    }

    @Nullable
    public UsernamePasswordContext getUsernamePasswordContext() {
        return this.upContext;
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.upContext = (UsernamePasswordContext)authenticationContext.getSubcontext(UsernamePasswordContext.class);
        if (this.upContext == null) {
            this.log.info("{} No UsernamePasswordContext available within authentication context", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            return false;
        }
        if (this.upContext.getUsername() == null) {
            this.log.info("{} No username available within UsernamePasswordContext", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            return false;
        }
        if (this.upContext.getPassword() == null) {
            this.log.info("{} No password available within UsernamePasswordContext", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "InvalidCredentials", "InvalidCredentials");
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject) {
        subject.getPrincipals().add(new UsernamePrincipal(this.upContext.getUsername()));
        if (this.savePasswordToCredentialSet) {
            subject.getPrivateCredentials().add(new PasswordPrincipal(this.upContext.getPassword()));
        }
        return subject;
    }
}

