/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.context;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapConstraint;
import com.google.common.collect.MapConstraints;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;

@NotThreadSafe
public class AttributeResolutionContext
extends BaseContext {
    @Nonnull
    @NonnullElements
    private Set<String> requestedAttributeNames = Collections.emptySet();
    @Nullable
    private String principal;
    @Nullable
    private String attributeIssuerID;
    @Nullable
    private String attributeRecipientID;
    @Nullable
    private String principalAuthenticationMethod;
    @Nonnull
    @NonnullElements
    private Map<String, IdPAttribute> resolvedAttributes = MapConstraints.constrainedMap(new HashMap(), (MapConstraint)MapConstraints.notNull());

    @Nullable
    public String getAttributeIssuerID() {
        return this.attributeIssuerID;
    }

    @Nullable
    public void setAttributeIssuerID(@Nullable String value) {
        this.attributeIssuerID = value;
    }

    @Nullable
    public String getAttributeRecipientID() {
        return this.attributeRecipientID;
    }

    @Nullable
    public void setAttributeRecipientID(@Nullable String value) {
        this.attributeRecipientID = value;
    }

    @Nullable
    public String getPrincipalAuthenticationMethod() {
        return this.principalAuthenticationMethod;
    }

    public void setPrincipalAuthenticationMethod(@Nullable String method) {
        this.principalAuthenticationMethod = method;
    }

    @Nullable
    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(@Nullable String who) {
        this.principal = who;
    }

    @Nonnull
    @NonnullElements
    public Collection<String> getRequestedIdPAttributeNames() {
        return this.requestedAttributeNames;
    }

    public void setRequestedIdPAttributeNames(@Nonnull @NonnullElements Collection<String> names) {
        Constraint.isNotNull(names, (String)"Requested IdPAttribute collection cannot be null");
        this.requestedAttributeNames = new HashSet<String>(Collections2.filter(names, (Predicate)Predicates.notNull()));
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public Map<String, IdPAttribute> getResolvedIdPAttributes() {
        return ImmutableMap.copyOf(this.resolvedAttributes);
    }

    public void setResolvedIdPAttributes(@Nullable @NullableElements Collection<IdPAttribute> attributes) {
        this.resolvedAttributes = new HashMap<String, IdPAttribute>();
        if (attributes != null) {
            for (IdPAttribute attribute : attributes) {
                if (attribute == null) continue;
                this.resolvedAttributes.put(attribute.getId(), attribute);
            }
        }
    }
}

