/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AbstractResolverPlugin;
import net.shibboleth.idp.attribute.resolver.DataConnectorEx;
import net.shibboleth.idp.attribute.resolver.MultipleResultAnErrorResolutionException;
import net.shibboleth.idp.attribute.resolver.NoResultAnErrorResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractDataConnector
extends AbstractResolverPlugin<Map<String, IdPAttribute>>
implements DataConnectorEx {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractDataConnector.class);
    @Nullable
    private String failoverDataConnectorId;
    @Nullable
    private String logPrefix;
    private long lastFail;
    @Duration
    private long noRetryDelay;

    @Override
    @Nullable
    public String getFailoverDataConnectorId() {
        return this.failoverDataConnectorId;
    }

    public void setFailoverDataConnectorId(@Nullable String id) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.failoverDataConnectorId = StringSupport.trimOrNull((String)id);
    }

    public void setLastFail(long time) {
        this.lastFail = time;
    }

    @Override
    public long getLastFail() {
        return this.lastFail;
    }

    public void setNoRetryDelay(@Duration long delay) {
        this.noRetryDelay = delay;
    }

    @Override
    public long getNoRetryDelay() {
        return this.noRetryDelay;
    }

    @Override
    @Nullable
    public final Map<String, IdPAttribute> doResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        Map<String, IdPAttribute> result;
        try {
            result = this.doDataConnectorResolve(resolutionContext, workContext);
        }
        catch (MultipleResultAnErrorResolutionException | NoResultAnErrorResolutionException e) {
            throw e;
        }
        catch (Exception e) {
            this.setLastFail(System.currentTimeMillis());
            throw e;
        }
        if (null == result) {
            this.log.debug("{} no attributes were produced during resolution", (Object)this.getId());
            return result;
        }
        this.log.debug("{} produced the following {} attributes during resolution {}", new Object[]{this.getLogPrefix(), result.size(), result.keySet()});
        for (String attrName : result.keySet()) {
            IdPAttribute attr = result.get(attrName);
            this.log.debug("{} Attribute '{}': Values '{}'", new Object[]{this.getLogPrefix(), attrName, attr.getValues()});
        }
        return result;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.logPrefix = null;
    }

    @Nullable
    protected abstract Map<String, IdPAttribute> doDataConnectorResolve(@Nonnull AttributeResolutionContext var1, @Nonnull AttributeResolverWorkContext var2) throws ResolutionException;

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        String prefix = this.logPrefix;
        if (null == prefix) {
            StringBuilder builder = new StringBuilder("Data Connector '").append(this.getId()).append("':");
            prefix = builder.toString();
            if (null == this.logPrefix) {
                this.logPrefix = prefix;
            }
        }
        return prefix;
    }
}

