/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute;

import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.attribute.AttributeEncoder;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

@NotThreadSafe
public class IdPAttribute
implements Comparable<IdPAttribute>,
Cloneable {
    private final String id;
    private Map<Locale, String> displayNames;
    private Map<Locale, String> displayDescriptions;
    private List<IdPAttributeValue<?>> values;
    private Set<AttributeEncoder<?>> encoders;

    public IdPAttribute(@Nonnull @ParameterName(name="attributeId") @NotEmpty String attributeId) {
        this.id = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)attributeId), (String)"Attribute ID may not be null");
        this.displayNames = Collections.emptyMap();
        this.displayDescriptions = Collections.emptyMap();
        this.values = Collections.emptyList();
        this.encoders = Collections.emptySet();
    }

    @Nonnull
    @NotEmpty
    public String getId() {
        return this.id;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<Locale, String> getDisplayNames() {
        return this.displayNames;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    private Map<Locale, String> checkedNamesFrom(@Nullable @NullableElements Map<Locale, String> inputMap) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (inputMap != null) {
            for (Map.Entry<Locale, String> entry : inputMap.entrySet()) {
                String trimmedName;
                if (entry.getKey() == null || (trimmedName = StringSupport.trimOrNull((String)entry.getValue())) == null) continue;
                builder.put((Object)entry.getKey(), (Object)trimmedName);
            }
        }
        return builder.build();
    }

    public void setDisplayNames(@Nullable @NullableElements Map<Locale, String> newNames) {
        this.displayNames = this.checkedNamesFrom(newNames);
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<Locale, String> getDisplayDescriptions() {
        return this.displayDescriptions;
    }

    public void setDisplayDescriptions(@Nullable @NullableElements Map<Locale, String> newDescriptions) {
        this.displayDescriptions = this.checkedNamesFrom(newDescriptions);
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public List<IdPAttributeValue<?>> getValues() {
        return this.values;
    }

    public void setValues(@Nullable @NullableElements Collection<? extends IdPAttributeValue<?>> newValues) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (newValues != null) {
            builder.addAll((Iterable)Collections2.filter(newValues, (Predicate)Predicates.notNull()));
        }
        this.values = builder.build();
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Set<AttributeEncoder<?>> getEncoders() {
        return this.encoders;
    }

    public void setEncoders(@Nullable @NullableElements Collection<AttributeEncoder<?>> newEncoders) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (newEncoders != null) {
            builder.addAll((Iterable)Collections2.filter(newEncoders, (Predicate)Predicates.notNull()));
        }
        this.encoders = builder.build();
    }

    @Override
    public int compareTo(IdPAttribute other) {
        return this.getId().compareTo(other.getId());
    }

    @Nonnull
    public IdPAttribute clone() throws CloneNotSupportedException {
        IdPAttribute clone = (IdPAttribute)super.clone();
        clone.setDisplayDescriptions(this.getDisplayDescriptions());
        clone.setDisplayNames(this.getDisplayNames());
        clone.setEncoders(this.getEncoders());
        clone.setValues(this.getValues());
        return clone;
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.id, this.values});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdPAttribute)) {
            return false;
        }
        IdPAttribute other = (IdPAttribute)obj;
        return Objects.equals(this.id, other.getId());
    }

    @Nonnull
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("displayNames", this.displayNames).add("displayDescriptions", this.displayDescriptions).add("encoders", this.encoders).add("values", this.values).toString();
    }
}

