/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.velocity;

import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.velocity.VelocityConfig;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.NestedIOException;
import org.springframework.web.servlet.view.AbstractTemplateView;
import org.springframework.web.util.NestedServletException;

public class VelocityView
extends AbstractTemplateView {
    @Nullable
    private String encoding;
    private boolean cacheTemplate;
    @Nullable
    private VelocityEngine velocityEngine;
    @Nullable
    private Template template;

    public void setEncoding(@Nullable String enc) {
        this.encoding = enc;
    }

    @Nullable
    protected String getEncoding() {
        return this.encoding;
    }

    public void setCacheTemplate(boolean flag) {
        this.cacheTemplate = flag;
    }

    protected boolean isCacheTemplate() {
        return this.cacheTemplate;
    }

    public void setVelocityEngine(@Nullable VelocityEngine engine) {
        this.velocityEngine = engine;
    }

    @Nullable
    protected VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    protected void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        if (this.getVelocityEngine() == null) {
            this.setVelocityEngine(this.autodetectVelocityEngine());
        }
    }

    @Nonnull
    protected VelocityEngine autodetectVelocityEngine() throws BeansException {
        try {
            VelocityConfig velocityConfig = (VelocityConfig)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), VelocityConfig.class, (boolean)true, (boolean)false);
            return velocityConfig.getVelocityEngine();
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new ApplicationContextException("Must define a single VelocityConfig bean in this web application context (may be inherited): VelocityConfigurer is the usual implementation. This bean may be given any name.", (Throwable)ex);
        }
    }

    public boolean checkResource(@Nullable Locale locale) throws Exception {
        try {
            this.template = this.getTemplate(this.getUrl());
            return true;
        }
        catch (ResourceNotFoundException ex) {
            return false;
        }
        catch (Exception ex) {
            throw new NestedIOException("Could not load Velocity template for URL [" + this.getUrl() + "]", (Throwable)ex);
        }
    }

    protected void renderMergedTemplateModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Context velocityContext = this.createVelocityContext(model, request, response);
        this.doRender(velocityContext, response);
    }

    protected Context createVelocityContext(@Nullable Map<String, Object> model, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws Exception {
        return this.createVelocityContext(model);
    }

    protected Context createVelocityContext(Map<String, Object> model) throws Exception {
        return new VelocityContext(model);
    }

    protected void doRender(Context context, HttpServletResponse response) throws Exception {
        this.mergeTemplate(this.getTemplate(), context, response);
    }

    protected Template getTemplate() throws Exception {
        if (this.isCacheTemplate() && this.template != null) {
            return this.template;
        }
        return this.getTemplate(this.getUrl());
    }

    protected Template getTemplate(String name) throws Exception {
        return this.getEncoding() != null ? this.getVelocityEngine().getTemplate(name, this.getEncoding()) : this.getVelocityEngine().getTemplate(name);
    }

    protected void mergeTemplate(Template t, Context context, @Nonnull HttpServletResponse response) throws Exception {
        try {
            t.merge(context, (Writer)response.getWriter());
        }
        catch (MethodInvocationException ex) {
            Throwable cause = ex.getCause();
            throw new NestedServletException("Method invocation failed during rendering of Velocity view with name '" + this.getBeanName() + "': " + ex.getMessage() + "; reference [" + ex.getReferenceName() + "], method '" + ex.getMethodName() + "'", cause == null ? ex : cause);
        }
    }
}

