/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.factory;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;

public class PKCS11PrivateKeyFactoryBean
implements FactoryBean<PrivateKey> {
    private static final String UNCONFIGURED_PROVIDER_NAME = "SunPKCS11";
    private static Provider provider;
    private final Logger log = LoggerFactory.getLogger(PKCS11PrivateKeyFactoryBean.class);
    private String pkcs11Config;
    private String keyAlias;
    private String keyPassword;
    private PrivateKey key;

    public String getPkcs11Config() {
        return this.pkcs11Config;
    }

    public void setPkcs11Config(@Nonnull String config) {
        this.pkcs11Config = config;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String alias) {
        this.keyAlias = alias;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(@Nonnull String password) {
        this.keyPassword = password;
    }

    private Provider getProvider() throws Exception {
        if (provider == null) {
            Provider baseProvider = Security.getProvider(UNCONFIGURED_PROVIDER_NAME);
            if (baseProvider == null) {
                throw new NoSuchProviderException("could not acquire PKCS#11 bridge: SunPKCS11");
            }
            provider = baseProvider.configure(this.pkcs11Config);
            Security.addProvider(provider);
        }
        return provider;
    }

    private KeyStore getKeyStore() throws Exception {
        KeyStore keystore = KeyStore.getInstance("PKCS11", this.getProvider());
        this.log.debug("Initializing PKCS11 keystore");
        keystore.load(null, this.keyPassword.toCharArray());
        return keystore;
    }

    public PrivateKey getObject() throws Exception {
        if (this.key == null) {
            KeyStore keystore = this.getKeyStore();
            KeyStore.Entry keyEntry = keystore.getEntry(this.keyAlias, new KeyStore.PasswordProtection(this.keyPassword.toCharArray()));
            if (keyEntry == null) {
                throw new GeneralSecurityException("entry " + this.keyAlias + " not found");
            }
            if (keyEntry instanceof KeyStore.PrivateKeyEntry) {
                KeyStore.PrivateKeyEntry privKeyEntry = (KeyStore.PrivateKeyEntry)keyEntry;
                this.key = privKeyEntry.getPrivateKey();
            } else {
                throw new GeneralSecurityException("entry " + this.keyAlias + " is not a private key entry");
            }
        }
        return this.key;
    }

    @Nonnull
    public Class<?> getObjectType() {
        return PrivateKey.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

