/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.util;

import net.shibboleth.ext.spring.util.AnnotationParameterNameDiscoverer;
import net.shibboleth.ext.spring.util.ParamClass;
import net.shibboleth.ext.spring.util.SchemaTypeAwareXMLBeanDefinitionReader;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.ParameterNameDiscoverer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ParameterNameAnnotationTest {
    @Test
    public void testNoAnnotationFilter() {
        GenericApplicationContext context = new GenericApplicationContext();
        SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)context);
        beanDefinitionReader.setValidationMode(3);
        beanDefinitionReader.loadBeanDefinitions("net/shibboleth/ext/spring/util/paramBeans.xml");
        context.refresh();
        ParamClass byNumber = (ParamClass)context.getBean("TheBeanRemainsTheSame", ParamClass.class);
        Assert.assertEquals((String)byNumber.getP1(), (String)"Param the First");
        Assert.assertEquals((String)byNumber.getP2(), (String)"Param the Second");
        ParamClass byId = (ParamClass)context.getBean("InThroughTheOutBean", ParamClass.class);
        Assert.assertEquals((String)byId.getP1(), (String)"Param the Second");
        Assert.assertEquals((String)byId.getP2(), (String)"Param the First");
        ParamClass single = (ParamClass)context.getBean("SingleParam", ParamClass.class);
        Assert.assertEquals((String)single.getP1(), (String)"Param the First");
        Assert.assertEquals((String)single.getP2(), (String)"HardWired Param The Second");
    }

    @Test(enabled=true)
    public void testWithAnnotationFilter() {
        GenericApplicationContext context = new GenericApplicationContext();
        SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)context);
        ConfigurableListableBeanFactory factory = context.getBeanFactory();
        if (factory instanceof AbstractAutowireCapableBeanFactory) {
            AbstractAutowireCapableBeanFactory aaBeanFactory = (AbstractAutowireCapableBeanFactory)factory;
            aaBeanFactory.setParameterNameDiscoverer((ParameterNameDiscoverer)new AnnotationParameterNameDiscoverer());
        }
        beanDefinitionReader.setValidationMode(3);
        beanDefinitionReader.loadBeanDefinitions("net/shibboleth/ext/spring/util/paramBeans.xml");
        context.refresh();
        ParamClass byNumber = (ParamClass)context.getBean("TheBeanRemainsTheSame", ParamClass.class);
        Assert.assertEquals((String)byNumber.getP1(), (String)"Param the First");
        Assert.assertEquals((String)byNumber.getP2(), (String)"Param the Second");
        ParamClass byId = (ParamClass)context.getBean("InThroughTheOutBean", ParamClass.class);
        Assert.assertEquals((String)byId.getP1(), (String)"Param the First");
        Assert.assertEquals((String)byId.getP2(), (String)"Param the Second");
        ParamClass single = (ParamClass)context.getBean("SingleParam", ParamClass.class);
        Assert.assertEquals((String)single.getP1(), (String)"Param the First");
        Assert.assertEquals((String)single.getP2(), (String)"HardWired Param The Second");
    }
}

