/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.resource;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.resource.ResourceHelper;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiedInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;

public class ConditionalResource
extends AbstractIdentifiedInitializableComponent
implements org.springframework.core.io.Resource,
BeanNameAware,
Resource {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_CONTENT = "<beans xmlns=\"http://www.springframework.org/schema/beans\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\"></beans>";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ConditionalResource.class);
    @Nullable
    private String logPrefix;
    @Nonnull
    private final org.springframework.core.io.Resource wrappedResource;
    @NonnullAfterInit
    private String defaultContent;

    public ConditionalResource(@Nonnull org.springframework.core.io.Resource wrapped) {
        this.wrappedResource = (org.springframework.core.io.Resource)Constraint.isNotNull((Object)wrapped, (String)"Wrapped resource cannot be null");
        this.defaultContent = DEFAULT_CONTENT;
    }

    public synchronized void setId(@Nonnull @NotEmpty String id) {
        super.setId(id);
    }

    public void setDefaultContent(@Nonnull String content) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.defaultContent = Constraint.isNotEmpty((String)content, (String)"Empty content cannot be null");
    }

    @Nonnull
    public InputStream getInputStream() throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        try {
            return this.wrappedResource.getInputStream();
        }
        catch (IOException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("{} getInputStream failed on wrapped resource", (Object)this.getLogPrefix(), (Object)e);
            } else {
                this.log.debug("{} getInputStream failed on wrapped resource", (Object)this.getLogPrefix());
            }
            return new ByteArrayInputStream(this.defaultContent.getBytes(StandardCharsets.UTF_8));
        }
    }

    public Resource createRelativeResource(String relativePath) throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        org.springframework.core.io.Resource relative = this.wrappedResource.createRelative(relativePath);
        if (relative instanceof Resource) {
            return (Resource)relative;
        }
        return ResourceHelper.of(relative);
    }

    public void setBeanName(String name) {
        this.setId(name);
    }

    public boolean exists() {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (!this.wrappedResource.exists()) {
            this.log.debug("{} Wrapped resource does not exist", (Object)this.getLogPrefix());
        }
        return true;
    }

    public boolean isReadable() {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        return true;
    }

    public boolean isOpen() {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        return this.wrappedResource.isOpen();
    }

    public URL getURL() throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        try {
            return this.wrappedResource.getURL();
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} getURL failed on wrapped resource", (Object)this.getLogPrefix(), (Object)e);
            }
            return null;
        }
    }

    public URI getURI() throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        try {
            return this.wrappedResource.getURI();
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} getURI failed on wrapped resource", (Object)this.getLogPrefix(), (Object)e);
            }
            return null;
        }
    }

    public File getFile() throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        try {
            return this.wrappedResource.getFile();
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} getFile failed on wrapped resource", (Object)this.getLogPrefix(), (Object)e);
            }
            return null;
        }
    }

    public long contentLength() throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        try {
            return this.wrappedResource.contentLength();
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} contentLength failed on wrapped resource", (Object)this.getLogPrefix(), (Object)e);
            }
            return this.defaultContent.length();
        }
    }

    public long lastModified() throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        try {
            return this.wrappedResource.lastModified();
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} lastModified failed on wrapped resource", (Object)this.getLogPrefix(), (Object)e);
            }
            return 0L;
        }
    }

    public org.springframework.core.io.Resource createRelative(String relativePath) throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        return this.wrappedResource.createRelative(relativePath);
    }

    public String getFilename() {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        return this.wrappedResource.getFilename();
    }

    public String getDescription() {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        return this.wrappedResource.getDescription();
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        if (this.logPrefix != null) {
            return this.logPrefix;
        }
        this.logPrefix = "ConditionalResource " + this.getId() + ":";
        return this.logPrefix;
    }
}

