/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.factory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.ApplicationContext;

public class ProxiedFactoryBean<T>
extends AbstractFactoryBean<T> {
    @Nonnull
    private final Class<T> beanType;
    @Nullable
    @NotEmpty
    private String beanName;
    @Nullable
    @NotEmpty
    private String backupName;
    @Nonnull
    private final ReloadableService<ApplicationContext> contextService;

    public ProxiedFactoryBean(@Nonnull @ParameterName(name="service") ReloadableService<ApplicationContext> service, @Nonnull @ParameterName(name="type") Class<T> type) {
        this.beanType = (Class)Constraint.isNotNull(type, (String)"Bean type cannot be null");
        this.contextService = (ReloadableService)Constraint.isNotNull(service, (String)"Managed ApplicationContext service component cannot be null");
    }

    public ProxiedFactoryBean(@Nonnull @ParameterName(name="service") ReloadableService<ApplicationContext> service, @Nonnull @ParameterName(name="type") Class<T> type, @Nonnull @ParameterName(name="name") @NotEmpty String name) {
        this(service, type);
        this.beanName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Bean name cannot be null or empty");
    }

    public ProxiedFactoryBean(@Nonnull @ParameterName(name="service") ReloadableService<ApplicationContext> service, @Nonnull @ParameterName(name="type") Class<T> type, @Nonnull @ParameterName(name="name") @NotEmpty String name, @Nonnull @ParameterName(name="backup") @NotEmpty String backup) {
        this(service, type);
        this.beanName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Bean name cannot be null or empty");
        this.backupName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)backup), (String)"Backup bean name cannot be null or empty");
    }

    public Class<T> getObjectType() {
        return this.beanType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T createInstance() throws Exception {
        ServiceableComponent component = this.contextService.getServiceableComponent();
        if (component == null) {
            throw new BeanCreationException("ApplicationContext not available");
        }
        if (this.beanName != null) {
            block13: {
                Object object;
                try {
                    Object bean = ((ApplicationContext)component.getComponent()).getBean(this.beanName, this.beanType);
                    if (bean == null) break block13;
                    object = bean;
                }
                catch (NoSuchBeanDefinitionException e) {
                    if (this.backupName != null) {
                        Object object2 = ((ApplicationContext)component.getComponent()).getBean(this.backupName, this.beanType);
                        return (T)object2;
                    }
                    throw e;
                }
                return (T)object;
            }
            if (this.backupName != null) {
                Object object = ((ApplicationContext)component.getComponent()).getBean(this.backupName, this.beanType);
                return (T)object;
            }
            T t = null;
            return t;
        }
        Object object = ((ApplicationContext)component.getComponent()).getBean(this.beanType);
        return (T)object;
        finally {
            component.unpinComponent();
        }
    }
}

