/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.context;

import net.shibboleth.ext.spring.resource.ConditionalResourceResolver;
import net.shibboleth.ext.spring.util.AnnotationParameterNameDiscoverer;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class FilesystemGenericApplicationContext
extends GenericApplicationContext {
    public FilesystemGenericApplicationContext() {
        this.getDefaultListableBeanFactory().setParameterNameDiscoverer((ParameterNameDiscoverer)new AnnotationParameterNameDiscoverer());
        this.addProtocolResolver(new ConditionalResourceResolver());
    }

    public FilesystemGenericApplicationContext(DefaultListableBeanFactory beanFactory) {
        super(beanFactory);
        beanFactory.setParameterNameDiscoverer((ParameterNameDiscoverer)new AnnotationParameterNameDiscoverer());
    }

    public FilesystemGenericApplicationContext(ApplicationContext parent) {
        super(parent);
        this.getDefaultListableBeanFactory().setParameterNameDiscoverer((ParameterNameDiscoverer)new AnnotationParameterNameDiscoverer());
    }

    public FilesystemGenericApplicationContext(DefaultListableBeanFactory beanFactory, ApplicationContext parent) {
        super(beanFactory, parent);
        beanFactory.setParameterNameDiscoverer((ParameterNameDiscoverer)new AnnotationParameterNameDiscoverer());
    }

    protected Resource getResourceByPath(String path) {
        FileSystemResource r = new FileSystemResource(path);
        if (r.exists()) {
            return r;
        }
        return super.getResourceByPath(path);
    }
}

