/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.service;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.service.ApplicationContextServiceableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ApplicationContextServiceStrategy
implements Function<ApplicationContext, ServiceableComponent<ApplicationContext>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ApplicationContextServiceStrategy.class);

    @Nullable
    public ServiceableComponent<ApplicationContext> apply(@Nullable ApplicationContext appContext) {
        if (appContext != null) {
            ApplicationContextServiceableComponent wrapper = new ApplicationContextServiceableComponent();
            wrapper.setApplicationContext(appContext);
            wrapper.setId(appContext.getId());
            try {
                wrapper.initialize();
                return wrapper;
            }
            catch (ComponentInitializationException e) {
                this.log.error("Unable to initialize component wrapper for ApplicationContext", (Throwable)e);
            }
        }
        return null;
    }
}

