/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.factory;

import java.io.InputStream;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.cryptacular.util.CertUtil;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.io.Resource;

public class X509CertificateChainFactoryBean
implements FactoryBean<X509Certificate[]> {
    private Resource resource;
    private X509Certificate[] certificates;

    public void setResource(@Nonnull Resource res) {
        this.resource = (Resource)Constraint.isNotNull((Object)res, (String)"Certificate chain resource can not be null");
    }

    public X509Certificate[] getObject() throws Exception {
        if (this.certificates == null) {
            if (this.resource == null) {
                throw new BeanCreationException("Certificate chain resource must be provided in order to use this factory.");
            }
            try (InputStream is = this.resource.getInputStream();){
                this.certificates = CertUtil.readCertificateChain((InputStream)is);
            }
        }
        return this.certificates;
    }

    @Nonnull
    public Class<?> getObjectType() {
        return X509Certificate.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

