/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.factory;

import java.io.InputStream;
import net.shibboleth.ext.spring.factory.AbstractComponentAwareFactoryBean;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.core.io.Resource;

public class EvaluableScriptFactoryBean
extends AbstractComponentAwareFactoryBean<EvaluableScript> {
    private final Logger log = LoggerFactory.getLogger(EvaluableScript.class);
    private Resource resource;
    private String script;
    private String engineName;
    private String sourceId;

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource what) {
        this.resource = what;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String what) {
        this.script = what;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String what) {
        this.sourceId = what;
    }

    public String getEngineName() {
        return this.engineName;
    }

    public void setEngineName(String what) {
        this.engineName = what;
    }

    public Class<?> getObjectType() {
        return EvaluableScript.class;
    }

    @Override
    protected EvaluableScript doCreateInstance() throws Exception {
        if (null == this.script && null == this.resource) {
            this.log.error("{} A script or a resource must be supplied", (Object)this.sourceId);
            throw new BeanCreationException("A script or a resource must be supplied");
        }
        if (null != this.script && null != this.resource) {
            this.log.error("{} Only one of script or resource should be supplied", (Object)this.sourceId);
            throw new BeanCreationException("Only one of script or resource should be supplied");
        }
        if (null != this.resource) {
            this.script = StringSupport.inputStreamToString((InputStream)this.resource.getInputStream(), null);
        }
        this.log.debug("{} Script: {}", (Object)this.sourceId, (Object)this.script);
        if (null == this.engineName) {
            this.log.debug("{} default language", (Object)this.sourceId);
            return new EvaluableScript(this.script);
        }
        this.log.debug("{} language : {}", (Object)this.sourceId, (Object)this.engineName);
        return new EvaluableScript(this.engineName, this.script);
    }
}

