/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.rdl.syntax;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import net.sf.tweety.commons.ParserException;
import net.sf.tweety.commons.Signature;
import net.sf.tweety.logics.commons.syntax.Functor;
import net.sf.tweety.logics.commons.syntax.Predicate;
import net.sf.tweety.logics.commons.syntax.Variable;
import net.sf.tweety.logics.commons.syntax.interfaces.Conjuctable;
import net.sf.tweety.logics.commons.syntax.interfaces.Disjunctable;
import net.sf.tweety.logics.commons.syntax.interfaces.Term;
import net.sf.tweety.logics.fol.prover.FolTheoremProver;
import net.sf.tweety.logics.fol.syntax.Conjunction;
import net.sf.tweety.logics.fol.syntax.Disjunction;
import net.sf.tweety.logics.fol.syntax.FOLAtom;
import net.sf.tweety.logics.fol.syntax.FolFormula;
import net.sf.tweety.logics.fol.syntax.FolSignature;
import net.sf.tweety.logics.fol.syntax.RelationalFormula;
import net.sf.tweety.logics.rdl.DefaultTheory;
import net.sf.tweety.math.probability.Probability;

public class DefaultRule
extends RelationalFormula {
    private FolFormula pre;
    private Collection<FolFormula> jus;
    private FolFormula conc;

    public DefaultRule() {
    }

    public DefaultRule(FolFormula pre, FolFormula jus, FolFormula conc) throws ParserException {
        this(pre, Arrays.asList(jus), conc);
    }

    public DefaultRule(FolFormula pre, Collection<FolFormula> jus, FolFormula conc) throws ParserException {
        if (pre == null) {
            throw new ParserException("Prerequisite needed to form default rule.");
        }
        if (conc == null) {
            throw new ParserException("Conclusion needed to form default rule.");
        }
        if (jus == null) {
            throw new ParserException("Justification needed to form default rule.");
        }
        this.pre = pre;
        this.jus = new LinkedList<FolFormula>();
        this.jus.addAll(jus);
        this.conc = conc;
    }

    public boolean isNormal(DefaultTheory dt) {
        if (this.jus.size() != 1) {
            return false;
        }
        FolTheoremProver prover = FolTheoremProver.getDefaultProver();
        return prover.equivalent(dt.getFacts(), this.jus.iterator().next(), this.conc);
    }

    public FolFormula getPrerequisite() {
        return this.pre;
    }

    public Collection<FolFormula> getJustification() {
        return this.jus;
    }

    public FolFormula getConclusion() {
        return this.conc;
    }

    public Set<? extends Predicate> getPredicates() {
        Set result = this.pre.getPredicates();
        result.addAll(this.conc.getPredicates());
        for (FolFormula f : this.jus) {
            result.add(f.getPredicates());
        }
        return result;
    }

    public boolean isLiteral() {
        return false;
    }

    public Set<Variable> getQuantifierVariables() {
        Set vars = this.conc.getQuantifierVariables();
        vars.addAll(this.pre.getQuantifierVariables());
        for (FolFormula f : this.jus) {
            vars.addAll(f.getQuantifierVariables());
        }
        return vars;
    }

    public Set<Variable> getUnboundVariables() {
        Set unbound = this.conc.getUnboundVariables();
        unbound.addAll(this.pre.getUnboundVariables());
        for (FolFormula f : this.jus) {
            unbound.addAll(f.getUnboundVariables());
        }
        return unbound;
    }

    public boolean containsQuantifier() {
        boolean result = this.conc.containsQuantifier() || this.pre.containsQuantifier();
        for (FolFormula f : this.jus) {
            result |= f.containsQuantifier();
        }
        return result;
    }

    public boolean isWellBound() {
        if (!this.conc.isWellBound()) {
            return false;
        }
        if (!this.pre.isWellBound()) {
            return false;
        }
        for (FolFormula f : this.jus) {
            if (f.isWellBound()) continue;
            return false;
        }
        return true;
    }

    public boolean isWellBound(Set<Variable> boundVariables) {
        if (!this.conc.isWellBound(boundVariables)) {
            return false;
        }
        if (!this.pre.isWellBound(boundVariables)) {
            return false;
        }
        for (FolFormula f : this.jus) {
            if (f.isWellBound(boundVariables)) continue;
            return false;
        }
        return true;
    }

    public boolean isClosed() {
        if (!this.conc.isClosed()) {
            return false;
        }
        if (!this.pre.isClosed()) {
            return false;
        }
        for (FolFormula f : this.jus) {
            if (f.isClosed()) continue;
            return false;
        }
        return true;
    }

    public boolean isClosed(Set<Variable> boundVariables) {
        if (!this.conc.isClosed(boundVariables)) {
            return false;
        }
        if (!this.pre.isClosed(boundVariables)) {
            return false;
        }
        for (FolFormula f : this.jus) {
            if (f.isClosed(boundVariables)) continue;
            return false;
        }
        return true;
    }

    public Set<Term<?>> getTerms() {
        Set result = this.pre.getTerms();
        result.addAll(this.conc.getTerms());
        for (FolFormula f : this.jus) {
            result.addAll(f.getTerms());
        }
        return result;
    }

    public <C extends Term<?>> Set<C> getTerms(Class<C> cls) {
        Set result = this.pre.getTerms(cls);
        result.addAll(this.conc.getTerms(cls));
        for (FolFormula f : this.jus) {
            result.addAll(f.getTerms(cls));
        }
        return result;
    }

    public Set<FOLAtom> getAtoms() {
        Set atoms = this.conc.getAtoms();
        atoms.addAll(this.pre.getAtoms());
        for (FolFormula f : this.jus) {
            atoms.addAll(f.getAtoms());
        }
        return atoms;
    }

    public Set<Functor> getFunctors() {
        Set funs = this.conc.getFunctors();
        funs.addAll(this.pre.getFunctors());
        for (FolFormula f : this.jus) {
            funs.addAll(f.getFunctors());
        }
        return funs;
    }

    public RelationalFormula substitute(Term<?> v, Term<?> t) throws IllegalArgumentException {
        ArrayList<FolFormula> fs = new ArrayList<FolFormula>();
        for (FolFormula f : this.jus) {
            fs.add(f.substitute(v, t));
        }
        return new DefaultRule(this.pre.substitute(v, t), fs, this.conc.substitute(v, t));
    }

    public Probability getUniformProbability() {
        throw new UnsupportedOperationException("Uniform probability of default is undefined.");
    }

    public RelationalFormula complement() {
        throw new IllegalArgumentException("No complement of default");
    }

    public Disjunction combineWithOr(Disjunctable formula) {
        throw new IllegalArgumentException("Not combinable with or");
    }

    public Conjunction combineWithAnd(Conjuctable formula) {
        throw new IllegalArgumentException("Not combinable with and");
    }

    public FolSignature getSignature() {
        FolSignature result = this.pre.getSignature();
        result.addSignature((Signature)this.conc.getSignature());
        for (FolFormula f : this.jus) {
            result.addSignature((Signature)f.getSignature());
        }
        return result;
    }

    public String toString() {
        String result = this.pre + " :: ";
        Iterator<FolFormula> i = this.jus.iterator();
        if (i.hasNext()) {
            result = result + i.next();
        }
        while (i.hasNext()) {
            result = result + " ; " + i.next();
        }
        return result + " / " + this.conc;
    }

    public RelationalFormula clone() {
        try {
            return new DefaultRule(this.pre, this.jus, this.conc);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.conc == null ? 0 : this.conc.hashCode());
        result = 31 * result + (this.jus == null ? 0 : this.jus.hashCode());
        result = 31 * result + (this.pre == null ? 0 : this.pre.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DefaultRule) {
            DefaultRule d = (DefaultRule)((Object)o);
            for (FolFormula f : this.jus) {
                boolean b = false;
                for (FolFormula g : d.jus) {
                    b |= f.equals(g);
                }
                if (b) continue;
                return false;
            }
            return this.pre.equals(d.pre) && this.conc.equals(d.conc);
        }
        return false;
    }
}

