/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.rdl.semantics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.logics.fol.FolBeliefSet;
import net.sf.tweety.logics.fol.prover.FolTheoremProver;
import net.sf.tweety.logics.fol.syntax.FolFormula;
import net.sf.tweety.logics.fol.syntax.Negation;
import net.sf.tweety.logics.fol.syntax.RelationalFormula;
import net.sf.tweety.logics.rdl.DefaultTheory;
import net.sf.tweety.logics.rdl.syntax.DefaultRule;

public class DefaultSequence {
    private List<DefaultRule> defaults = new ArrayList<DefaultRule>();
    private Set<FolFormula> out = new HashSet<FolFormula>();
    private FolBeliefSet in = new FolBeliefSet();
    boolean process = true;

    public DefaultSequence(DefaultTheory dt) {
        this.in.addAll((Collection)dt.getFacts());
    }

    public DefaultSequence(DefaultSequence ds, DefaultRule d) {
        this.defaults.addAll(ds.defaults);
        this.in.addAll((Collection)ds.in);
        this.process = ds.isApplicable(d);
        for (DefaultRule r : this.defaults) {
            if (!d.equals((Object)r)) continue;
            this.process = false;
        }
        this.in.add((Formula)d.getConclusion());
        this.defaults.add(d);
        this.out.addAll(ds.out);
        for (FolFormula f : d.getJustification()) {
            this.out.add((FolFormula)new Negation((RelationalFormula)f));
        }
    }

    public DefaultSequence app(DefaultRule d) {
        return new DefaultSequence(this, d);
    }

    public boolean isApplicable(DefaultRule d) {
        FolTheoremProver prover = FolTheoremProver.getDefaultProver();
        for (FolFormula f : d.getJustification()) {
            if (!prover.query(this.in, (FolFormula)new Negation((RelationalFormula)f))) continue;
            return false;
        }
        return prover.query(this.in, d.getPrerequisite());
    }

    public Collection<FolFormula> getIn() {
        return this.in;
    }

    public Collection<FolFormula> getOut() {
        return this.out;
    }

    public boolean isProcess() {
        return this.process;
    }

    public boolean isSuccessful() {
        FolTheoremProver prover = FolTheoremProver.getDefaultProver();
        for (FolFormula g : this.out) {
            if (!prover.query(this.in, g)) continue;
            return false;
        }
        return true;
    }

    public boolean isClosed(DefaultTheory t) {
        for (DefaultRule d : t.getDefaults()) {
            if (!this.app(d).isProcess()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "DefaultSequence" + (this.isProcess() ? " is process" : "") + (this.isSuccessful() ? " is successfull" : "") + " [\n\tdefaults = " + this.defaults + ", \n\tout = " + this.out + ", \n\tin = " + this.in + "\n]";
    }
}

