/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.logics.rdl;

import java.util.Collection;
import net.sf.tweety.commons.Answer;
import net.sf.tweety.commons.BeliefBase;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.commons.Reasoner;
import net.sf.tweety.logics.fol.FolBeliefSet;
import net.sf.tweety.logics.fol.prover.FolTheoremProver;
import net.sf.tweety.logics.fol.syntax.FolFormula;
import net.sf.tweety.logics.rdl.DefaultTheory;
import net.sf.tweety.logics.rdl.semantics.DefaultProcessTree;

public class NaiveDefaultReasoner
extends Reasoner {
    DefaultProcessTree tree;

    public NaiveDefaultReasoner(BeliefBase beliefBase) {
        super(beliefBase);
        if (!(beliefBase instanceof DefaultTheory)) {
            throw new IllegalArgumentException("BeliefBase has to be a DefaultTheory");
        }
        this.tree = new DefaultProcessTree((DefaultTheory)beliefBase);
    }

    public Answer query(Formula query) {
        if (!(query instanceof FolFormula)) {
            throw new IllegalArgumentException("NaiveDefaultReasoner is only defined for first-order queries.");
        }
        if (!((FolFormula)query).isGround()) {
            throw new IllegalArgumentException("Query is not grounded.");
        }
        Answer answer = new Answer(this.getKnowledgBase(), query);
        answer.setAnswer(false);
        for (Collection<FolFormula> extension : this.tree.getExtensions()) {
            FolBeliefSet fbs = (FolBeliefSet)extension;
            FolTheoremProver prover = FolTheoremProver.getDefaultProver();
            if (!prover.query(fbs, (FolFormula)query)) continue;
            answer.setAnswer(true);
            break;
        }
        return answer;
    }

    public Collection<Collection<FolFormula>> getAllExtensions() {
        return this.tree.getExtensions();
    }
}

