/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.supercsv.io.ICsvWriter;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCsvWriter
implements ICsvWriter {
    private final BufferedWriter writer;
    private final CsvPreference preference;
    private int lineNumber = 0;
    private int rowNumber = 0;
    private final StringBuilder currentColumn = new StringBuilder();

    public AbstractCsvWriter(Writer writer, CsvPreference preference) {
        if (writer == null) {
            throw new NullPointerException("writer should not be null");
        }
        if (preference == null) {
            throw new NullPointerException("preference should not be null");
        }
        this.writer = new BufferedWriter(writer);
        this.preference = preference;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    protected String escapeString(String csvElement) {
        if (csvElement.length() == 0) {
            return "";
        }
        this.currentColumn.delete(0, this.currentColumn.length());
        int delimiter = this.preference.getDelimiterChar();
        char quote = (char)this.preference.getQuoteChar();
        int space = 32;
        String eolSymbols = this.preference.getEndOfLineSymbols();
        boolean surroundingSpacesNeedQuotes = this.preference.isSurroundingSpacesNeedQuotes();
        int lastCharIndex = csvElement.length() - 1;
        boolean needForEscape = surroundingSpacesNeedQuotes && (csvElement.charAt(0) == ' ' || csvElement.charAt(lastCharIndex) == ' ');
        for (int i = 0; i <= lastCharIndex; ++i) {
            char c = csvElement.charAt(i);
            if (c == delimiter) {
                needForEscape = true;
                this.currentColumn.append(c);
                continue;
            }
            if (c == quote) {
                needForEscape = true;
                this.currentColumn.append(quote);
                this.currentColumn.append(quote);
                continue;
            }
            if (c == '\n') {
                needForEscape = true;
                this.currentColumn.append(eolSymbols);
                ++this.lineNumber;
                continue;
            }
            this.currentColumn.append(c);
        }
        if (needForEscape) {
            this.currentColumn.insert(0, quote).append(quote);
        }
        return this.currentColumn.toString();
    }

    protected void incrementRowAndLineNo() {
        ++this.lineNumber;
        ++this.rowNumber;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getRowNumber() {
        return this.rowNumber;
    }

    protected void writeRow(List<?> columns) throws IOException {
        this.writeRow(Util.objectListToStringArray(columns));
    }

    protected void writeRow(Object ... columns) throws IOException {
        this.writeRow(Util.objectArrayToStringArray(columns));
    }

    protected void writeRow(String ... columns) throws IOException {
        if (columns == null) {
            throw new NullPointerException(String.format("columns to write should not be null on line %d", this.lineNumber));
        }
        if (columns.length == 0) {
            throw new IllegalArgumentException(String.format("columns to write should not be empty on line %d", this.lineNumber));
        }
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                this.writer.write(this.preference.getDelimiterChar());
            }
            if (columns[i] == null) continue;
            this.writer.write(this.escapeString(columns[i]));
        }
        this.writer.write(this.preference.getEndOfLineSymbols());
    }

    @Override
    public void writeHeader(String ... header) throws IOException {
        this.incrementRowAndLineNo();
        this.writeRow(header);
    }
}

