/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.prefs;

public final class CsvPreference {
    public static final CsvPreference STANDARD_PREFERENCE = new Builder('\"', 44, "\r\n").build();
    public static final CsvPreference EXCEL_PREFERENCE = new Builder('\"', 44, "\n").build();
    public static final CsvPreference EXCEL_NORTH_EUROPE_PREFERENCE = new Builder('\"', 59, "\n").build();
    public static final CsvPreference TAB_PREFERENCE = new Builder('\"', 9, "\n").build();
    private final char quoteChar;
    private final int delimiterChar;
    private final String endOfLineSymbols;
    private final boolean surroundingSpacesNeedQuotes;

    private CsvPreference(Builder builder) {
        this.quoteChar = builder.quoteChar;
        this.delimiterChar = builder.delimiterChar;
        this.endOfLineSymbols = builder.endOfLineSymbols;
        this.surroundingSpacesNeedQuotes = builder.surroundingSpacesNeedQuotes;
    }

    public int getDelimiterChar() {
        return this.delimiterChar;
    }

    public String getEndOfLineSymbols() {
        return this.endOfLineSymbols;
    }

    public int getQuoteChar() {
        return this.quoteChar;
    }

    public boolean isSurroundingSpacesNeedQuotes() {
        return this.surroundingSpacesNeedQuotes;
    }

    public static class Builder {
        private final char quoteChar;
        private final int delimiterChar;
        private final String endOfLineSymbols;
        private boolean surroundingSpacesNeedQuotes = false;

        public Builder(CsvPreference preference) {
            this.quoteChar = preference.quoteChar;
            this.delimiterChar = preference.delimiterChar;
            this.endOfLineSymbols = preference.endOfLineSymbols;
            this.surroundingSpacesNeedQuotes = preference.surroundingSpacesNeedQuotes;
        }

        public Builder(char quoteChar, int delimiterChar, String endOfLineSymbols) {
            if (quoteChar == delimiterChar) {
                throw new IllegalArgumentException(String.format("quoteChar and delimiterChar should not be the same character: %c", Character.valueOf(quoteChar)));
            }
            if (endOfLineSymbols == null) {
                throw new NullPointerException("endOfLineSymbols should not be null");
            }
            this.quoteChar = quoteChar;
            this.delimiterChar = delimiterChar;
            this.endOfLineSymbols = endOfLineSymbols;
        }

        public Builder surroundingSpacesNeedQuotes(boolean surroundingSpacesNeedQuotes) {
            this.surroundingSpacesNeedQuotes = surroundingSpacesNeedQuotes;
            return this;
        }

        public CsvPreference build() {
            return new CsvPreference(this);
        }
    }
}

