/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor.joda;

import org.joda.time.Period;
import org.joda.time.format.PeriodFormatter;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.util.CsvContext;

public class ParsePeriod
extends CellProcessorAdaptor {
    private final PeriodFormatter formatter;

    public ParsePeriod() {
        this.formatter = null;
    }

    public ParsePeriod(CellProcessor next) {
        super(next);
        this.formatter = null;
    }

    public ParsePeriod(PeriodFormatter formatter) {
        ParsePeriod.checkPreconditions(formatter);
        this.formatter = formatter;
    }

    public ParsePeriod(PeriodFormatter formatter, CellProcessor next) {
        super(next);
        ParsePeriod.checkPreconditions(formatter);
        this.formatter = formatter;
    }

    private static void checkPreconditions(PeriodFormatter formatter) {
        if (formatter == null) {
            throw new NullPointerException("formatter should not be null");
        }
    }

    public Object execute(Object value, CsvContext context) {
        Period result;
        this.validateInputNotNull(value, context);
        if (!(value instanceof String)) {
            throw new SuperCsvCellProcessorException(String.class, value, context, (CellProcessor)this);
        }
        String string = (String)value;
        try {
            result = this.formatter != null ? Period.parse((String)string, (PeriodFormatter)this.formatter) : Period.parse((String)string);
        }
        catch (IllegalArgumentException e) {
            throw new SuperCsvCellProcessorException("Failed to parse value as a Period", context, (CellProcessor)this, (Throwable)e);
        }
        return this.next.execute((Object)result, context);
    }
}

