/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor.joda;

import java.util.Locale;
import org.joda.time.format.DateTimeFormatter;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.util.CsvContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJodaFormattingProcessor<T>
extends CellProcessorAdaptor {
    private final Class<T> jodaClass;
    private final DateTimeFormatter formatter;
    private final String pattern;
    private final Locale locale;

    public AbstractJodaFormattingProcessor(Class<T> jodaClass) {
        AbstractJodaFormattingProcessor.checkPreconditions(jodaClass);
        this.jodaClass = jodaClass;
        this.formatter = null;
        this.pattern = null;
        this.locale = null;
    }

    public AbstractJodaFormattingProcessor(Class<T> jodaClass, CellProcessor next) {
        super(next);
        AbstractJodaFormattingProcessor.checkPreconditions(jodaClass);
        this.jodaClass = jodaClass;
        this.formatter = null;
        this.pattern = null;
        this.locale = null;
    }

    public AbstractJodaFormattingProcessor(Class<T> jodaClass, DateTimeFormatter formatter) {
        AbstractJodaFormattingProcessor.checkPreconditions(jodaClass, formatter);
        this.jodaClass = jodaClass;
        this.formatter = formatter;
        this.pattern = null;
        this.locale = null;
    }

    public AbstractJodaFormattingProcessor(Class<T> jodaClass, DateTimeFormatter formatter, CellProcessor next) {
        super(next);
        AbstractJodaFormattingProcessor.checkPreconditions(jodaClass, formatter);
        this.jodaClass = jodaClass;
        this.formatter = formatter;
        this.pattern = null;
        this.locale = null;
    }

    public AbstractJodaFormattingProcessor(Class<T> jodaClass, String pattern) {
        this(jodaClass, pattern, (Locale)null);
    }

    public AbstractJodaFormattingProcessor(Class<T> jodaClass, String pattern, CellProcessor next) {
        this(jodaClass, pattern, null, next);
    }

    public AbstractJodaFormattingProcessor(Class<T> jodaClass, String pattern, Locale locale) {
        AbstractJodaFormattingProcessor.checkPreconditions(jodaClass, pattern);
        this.jodaClass = jodaClass;
        this.pattern = pattern;
        this.locale = locale;
        this.formatter = null;
    }

    public AbstractJodaFormattingProcessor(Class<T> jodaClass, String pattern, Locale locale, CellProcessor next) {
        super(next);
        AbstractJodaFormattingProcessor.checkPreconditions(jodaClass, pattern);
        this.jodaClass = jodaClass;
        this.pattern = pattern;
        this.locale = locale;
        this.formatter = null;
    }

    private static void checkPreconditions(Class<?> jodaClass) {
        if (jodaClass == null) {
            throw new NullPointerException("jodaClass should not be null");
        }
    }

    private static void checkPreconditions(Class<?> jodaClass, DateTimeFormatter formatter) {
        if (jodaClass == null) {
            throw new NullPointerException("jodaClass should not be null");
        }
        if (formatter == null) {
            throw new NullPointerException("formatter should not be null");
        }
    }

    private static void checkPreconditions(Class<?> jodaClass, String pattern) {
        if (jodaClass == null) {
            throw new NullPointerException("jodaClass should not be null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern should not be null");
        }
    }

    public Object execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        if (!value.getClass().equals(this.jodaClass)) {
            throw new SuperCsvCellProcessorException(this.jodaClass, value, context, (CellProcessor)this);
        }
        T jodaType = this.jodaClass.cast(value);
        try {
            if (this.formatter != null) {
                return this.format(jodaType, this.formatter);
            }
            if (this.pattern != null) {
                return this.format(jodaType, this.pattern, this.locale);
            }
            return this.format(jodaType);
        }
        catch (IllegalArgumentException e) {
            throw new SuperCsvCellProcessorException(String.format("Failed to format value as a %s", this.jodaClass.getSimpleName()), context, (CellProcessor)this, (Throwable)e);
        }
    }

    protected abstract String format(T var1, DateTimeFormatter var2);

    protected abstract String format(T var1, String var2, Locale var3);

    protected abstract String format(T var1);
}

