/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor.time;

import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.Map;
import java.util.Objects;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.util.CsvContext;

public class ParseZoneId
extends CellProcessorAdaptor {
    private final Map<String, String> aliasMap;

    public ParseZoneId() {
        this.aliasMap = null;
    }

    public ParseZoneId(CellProcessor next) {
        super(next);
        this.aliasMap = null;
    }

    public ParseZoneId(Map<String, String> aliasMap) {
        Objects.requireNonNull(aliasMap);
        this.aliasMap = aliasMap;
    }

    public ParseZoneId(Map<String, String> aliasMap, CellProcessor next) {
        super(next);
        Objects.requireNonNull(aliasMap);
        this.aliasMap = aliasMap;
    }

    public Object execute(Object value, CsvContext context) {
        ZoneId result;
        this.validateInputNotNull(value, context);
        if (!(value instanceof String)) {
            throw new SuperCsvCellProcessorException(String.class, value, context, (CellProcessor)this);
        }
        try {
            result = this.aliasMap != null ? ZoneId.of((String)value, this.aliasMap) : ZoneId.of((String)value);
        }
        catch (DateTimeException e) {
            throw new SuperCsvCellProcessorException("Failed to parse value as a ZoneId", context, (CellProcessor)this, (Throwable)e);
        }
        return this.next.execute((Object)result, context);
    }
}

