/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.util;

import java.io.PrintStream;
import java.io.Serializable;
import net.sf.sojo.util.StackTraceElementWrapper;

public final class ThrowableWrapper
implements Serializable {
    private static final long serialVersionUID = -9139232450743630651L;
    private String message = "no message available";
    private String exceptionClassName = "no exception class name available";
    private StackTraceElementWrapper[] stackTraceElementWrapperList = new StackTraceElementWrapper[0];
    private ThrowableWrapper causeWrapper = null;

    public ThrowableWrapper() {
    }

    public ThrowableWrapper(Throwable pvThrowable) {
        if (pvThrowable == null) {
            throw new NullPointerException("The parameter Throwable must be different from value null.");
        }
        this.setMessage(pvThrowable.getMessage());
        this.setExceptionClassName(pvThrowable.getClass().getName());
        this.copyStackTraceElement(pvThrowable.getStackTrace());
        this.convertCause2Wrapper(pvThrowable, this);
    }

    public void setMessage(String pvMessage) {
        this.message = pvMessage;
    }

    public String getMessage() {
        return this.message;
    }

    public void setExceptionClassName(String pvExceptionClassName) {
        this.exceptionClassName = pvExceptionClassName;
    }

    public String getExceptionClassName() {
        return this.exceptionClassName;
    }

    public ThrowableWrapper getCauseWrapper() {
        return this.causeWrapper;
    }

    public void setCauseWrapper(ThrowableWrapper pvCauseWrapper) {
        this.causeWrapper = pvCauseWrapper;
    }

    public StackTraceElementWrapper[] getStackTraceElementWrapperList() {
        return this.stackTraceElementWrapperList;
    }

    public void setStackTraceElementWrapperList(StackTraceElementWrapper[] pvStackTraceElementWrappers) {
        this.stackTraceElementWrapperList = pvStackTraceElementWrappers;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream pvPrintStream) {
        int lvSize = this.stackTraceElementWrapperList.length;
        pvPrintStream.println(String.valueOf(this.getExceptionClassName()) + ": " + this.getMessage());
        int i = 0;
        while (i < lvSize) {
            pvPrintStream.println("  at " + this.stackTraceElementWrapperList[i]);
            ++i;
        }
    }

    private void convertCause2Wrapper(Throwable pvThrowable, ThrowableWrapper pvThrowableWrapper) {
        Throwable lvCause = pvThrowable.getCause();
        if (lvCause != null) {
            ThrowableWrapper lvWrapper = new ThrowableWrapper(lvCause);
            pvThrowableWrapper.setCauseWrapper(lvWrapper);
            this.convertCause2Wrapper(lvCause, lvWrapper);
        }
    }

    private void copyStackTraceElement(StackTraceElement[] pvStackTraceElements) {
        int lvArraySize = pvStackTraceElements.length;
        this.stackTraceElementWrapperList = new StackTraceElementWrapper[lvArraySize];
        int i = 0;
        while (i < lvArraySize) {
            this.stackTraceElementWrapperList[i] = new StackTraceElementWrapper(pvStackTraceElements[i]);
            ++i;
        }
    }
}

