/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.core.filter;

import java.util.Iterator;
import java.util.Map;
import net.sf.sojo.core.filter.ClassPropertyFilter;
import net.sf.sojo.core.filter.ClassPropertyFilterHandler;
import net.sf.sojo.core.reflect.ReflectionMethodHelper;

public class ClassPropertyFilterHelper {
    public static boolean isPropertyToFiltering(ClassPropertyFilterHandler pvClassPropertyFilterHandler, Class pvClassForFindFilter, Object pvKey) {
        boolean lvAddProperty = false;
        if (pvClassPropertyFilterHandler != null) {
            String lvKey;
            ClassPropertyFilter lvClassPropertyFilter = pvClassPropertyFilterHandler.getClassPropertyFilterByClass(pvClassForFindFilter);
            String string = lvKey = pvKey == null ? null : pvKey.toString();
            if (lvClassPropertyFilter != null && lvClassPropertyFilter.isKnownProperty(lvKey)) {
                lvAddProperty = true;
            }
        }
        return lvAddProperty;
    }

    public static ClassPropertyFilter createClassPropertyFilterByClass(Class pvClass) {
        ClassPropertyFilter lvClassPropertyFilter = new ClassPropertyFilter(pvClass);
        Map lvProperties = ReflectionMethodHelper.getAllGetterMethodWithCache(pvClass, null);
        Iterator it = lvProperties.keySet().iterator();
        while (it.hasNext()) {
            String lvProperty = (String)it.next();
            lvClassPropertyFilter.addProperty(lvProperty);
        }
        return lvClassPropertyFilter;
    }

    public static String validateClassPropertyFilter(ClassPropertyFilter pvClassPropertyFilter) {
        String lvReturn = null;
        if (pvClassPropertyFilter != null) {
            try {
                Class lvClass = pvClassPropertyFilter.getFilterClass();
                Map lvProperties = ReflectionMethodHelper.getAllGetterMethodWithCache(lvClass, null);
                String[] lvAllProperties = pvClassPropertyFilter.getAllProperties();
                int i = 0;
                while (i < lvAllProperties.length) {
                    if (!lvProperties.containsKey(lvAllProperties[i])) {
                        return lvAllProperties[i] + " is not a valid property name";
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                lvReturn = pvClassPropertyFilter.getFilterClass() + " is not a valid class name";
            }
        }
        return lvReturn;
    }
}

