/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.core.conversion.interceptor;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.sf.sojo.core.ConversionContext;
import net.sf.sojo.core.ConversionException;
import net.sf.sojo.core.ConverterInterceptorRecursive;
import net.sf.sojo.core.reflect.ReflectionHelper;

public class SimpleKeyMapperInterceptor
implements ConverterInterceptorRecursive {
    public static final String DELIMITER = "~_-_~";
    private boolean makeSimple = false;
    private Map keyMapper = new TreeMap(new SimpleKeyComparator());
    static /* synthetic */ Class class$0;

    public SimpleKeyMapperInterceptor() {
    }

    public SimpleKeyMapperInterceptor(boolean pvMakeSimple) {
        this.setMakeSimple(pvMakeSimple);
    }

    public void setMakeSimple(boolean pvMakeSimple) {
        this.makeSimple = pvMakeSimple;
    }

    public boolean getMakeSimple() {
        return this.makeSimple;
    }

    public void beforeConvertRecursion(ConversionContext pvContext) {
        if (this.getMakeSimple()) {
            this.toSimple(pvContext);
        }
    }

    public Object beforeConvert(Object pvConvertObject, Class pvToType) {
        Hashtable lvReturn = null;
        if (!this.getMakeSimple()) {
            Map lvMap = pvConvertObject;
            Map lvOrderedMap = this.map2SortedMap(lvMap);
            Iterator it = lvOrderedMap.entrySet().iterator();
            Hashtable lvHashtable = new Hashtable(lvMap.size());
            while (it.hasNext()) {
                Map.Entry lvMapEntry = it.next();
                SimpleKeyComparator lvKeyComparator = (SimpleKeyComparator)lvMapEntry.getKey();
                Object lvKey = lvKeyComparator.getKey();
                Object lvValue = lvMapEntry.getValue();
                lvHashtable.put(lvKey, lvValue);
            }
            lvReturn = lvHashtable;
        } else {
            lvReturn = pvConvertObject;
        }
        this.keyMapper.clear();
        return lvReturn;
    }

    protected void toSimple(ConversionContext pvContext) {
        String lvNewKey = null;
        lvNewKey = pvContext.key instanceof Date ? Long.toString(((Date)pvContext.key).getTime()) : pvContext.key.toString();
        int l = pvContext.key.toString().split(DELIMITER).length;
        if (l < 2) {
            Class<?> clazz = pvContext.key.getClass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            lvNewKey = clazz.equals(clazz2) ? String.valueOf(pvContext.numberOfRecursion) + DELIMITER + lvNewKey : String.valueOf(pvContext.numberOfRecursion) + DELIMITER + lvNewKey + DELIMITER + pvContext.key.getClass().getName();
        } else {
            lvNewKey = pvContext.key.toString();
        }
        pvContext.key = lvNewKey;
    }

    protected SimpleKeyComparator toComplex(Object pvKey) {
        if (!(pvKey instanceof String)) {
            throw new IllegalArgumentException("Expected String, but key is: " + pvKey + " -> class: " + pvKey.getClass().getName());
        }
        String lvKeyStr = (String)pvKey;
        String[] lvKeyArray = lvKeyStr.split(DELIMITER);
        if (lvKeyArray.length < 2) {
            throw new IllegalArgumentException("The key must contains  the delimiter: ~_-_~ - " + lvKeyStr + " (" + lvKeyArray.length + ")");
        }
        String lvPosStr = lvKeyArray[0];
        Integer integer = Integer.valueOf(lvPosStr);
        int lvPos = integer;
        String lvKeyValue = lvKeyArray[1];
        Object lvKey = null;
        if (lvKeyArray.length == 3) {
            String lvKeyClass = lvKeyArray[2];
            try {
                Class clazz = ReflectionHelper.forName(lvKeyClass);
                lvKey = ReflectionHelper.createNewSimpleObject(clazz, lvKeyValue);
            }
            catch (Exception e) {
                throw new ConversionException("Can't create a new instance of class: " + lvKeyClass + " with value: " + lvKeyValue);
            }
        } else {
            lvKey = lvKeyValue;
        }
        return new SimpleKeyComparator(lvPos, lvKey);
    }

    protected Map map2SortedMap(Map pvMap) {
        Iterator it = pvMap.entrySet().iterator();
        TreeMap lvTreeMap = new TreeMap(new SimpleKeyComparator());
        while (it.hasNext()) {
            Map.Entry lvEntry = it.next();
            Object lvKey = lvEntry.getKey();
            Object lvValue = lvEntry.getValue();
            SimpleKeyComparator skm = this.toComplex(lvKey);
            lvTreeMap.put(skm, lvValue);
        }
        return lvTreeMap;
    }

    public void afterConvertRecursion(ConversionContext pvContext) {
    }

    public Object afterConvert(Object pvResult, Class pvToType) {
        return pvResult;
    }

    public void onError(Exception pvException) {
    }

    private static class SimpleKeyComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 2873440526210140656L;
        private int pos = -1;
        private Object key = null;

        public SimpleKeyComparator() {
        }

        public SimpleKeyComparator(int pvPos, Object pvKey) {
            this.pos = pvPos;
            this.key = pvKey;
        }

        public int getPos() {
            return this.pos;
        }

        public Object getKey() {
            return this.key;
        }

        public int compare(Object pvO1, Object pvO2) {
            SimpleKeyComparator skm1 = (SimpleKeyComparator)pvO1;
            SimpleKeyComparator skm2 = (SimpleKeyComparator)pvO2;
            if (skm1.getPos() > skm2.getPos()) {
                return -1;
            }
            return 1;
        }
    }
}

