/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.core.conversion;

import java.util.Iterator;
import java.util.Map;
import net.sf.sojo.core.IConverter;
import net.sf.sojo.core.IConverterExtension;
import net.sf.sojo.core.IterateableConversion;
import net.sf.sojo.core.reflect.ReflectionHelper;

public class IterateableMap2MapConversion
extends IterateableConversion {
    public static final Class DEFAULT_MAP_TYPE;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.HashMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DEFAULT_MAP_TYPE = clazz;
    }

    public IterateableMap2MapConversion() {
        this(null, false);
    }

    public IterateableMap2MapConversion(Class pvNewIteratableType) {
        this(pvNewIteratableType, false);
    }

    public IterateableMap2MapConversion(Class pvNewIteratableType, boolean pvIgnoreNullValues) {
        this.newIteratableType = pvNewIteratableType;
        if (this.newIteratableType == null) {
            this.newIteratableType = DEFAULT_MAP_TYPE;
        }
        this.validateTargetIteratableType(this.newIteratableType);
        this.setIgnoreNullValues(pvIgnoreNullValues);
    }

    private void validateTargetIteratableType(Class pvIteratableType) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Map");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(pvIteratableType)) {
            throw new IllegalArgumentException("The class: " + pvIteratableType + " must be implements the java.util.Map interface.");
        }
        if (pvIteratableType.isInterface()) {
            throw new IllegalArgumentException("The class: " + pvIteratableType + " must be a implementation and not an interface.");
        }
    }

    public boolean isAssignableFrom(Object pvObject) {
        boolean lvReturn = false;
        if (ReflectionHelper.isMapType(pvObject) && !ReflectionHelper.isComplexMapType(pvObject)) {
            lvReturn = true;
        }
        return lvReturn;
    }

    public boolean isAssignableTo(Class pvToType) {
        return ReflectionHelper.isMapType(pvToType);
    }

    public Object convert(Object pvObject, Class pvToType, IConverterExtension pvConverter) {
        Class lvToType = pvToType == null || pvToType.isInterface() ? this.newIteratableType : pvToType;
        Map lvOldMap = (Map)pvObject;
        Map lvNewMap = (Map)ReflectionHelper.createNewIteratableInstance(lvToType, lvOldMap.size());
        Iterator iter = lvOldMap.entrySet().iterator();
        return super.iterate(pvObject, lvNewMap, iter, pvConverter);
    }

    protected Object[] doTransformIteratorObject2KeyValuePair(Object pvIteratorObject) {
        Map.Entry lvMapEntry = (Map.Entry)pvIteratorObject;
        Object lvKey = lvMapEntry.getKey();
        Object lvValue = lvMapEntry.getValue();
        return new Object[]{lvKey, lvValue};
    }

    protected Object[] doConvert(Object pvSourceObject, Object pvNewTargetObject, Object pvKey, Object pvValue, IConverter pvConverter) {
        Object lvKey = pvConverter.convert(pvKey);
        Object lvValue = pvConverter.convert(pvValue);
        return new Object[]{lvKey, lvValue};
    }

    protected void doAddObject(Object pvSourceObject, Object pvNewTargetObject, Object pvKey, Object pvValue, int pvIteratorPosition) {
        Map lvNewMap = (Map)pvNewTargetObject;
        lvNewMap.put(pvKey, pvValue);
    }
}

