/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.sojo.core.ConversionContext;
import net.sf.sojo.core.ConverterInterceptor;
import net.sf.sojo.core.ConverterInterceptorRecursive;

public class ConverterInterceptorHandler {
    private List interceptors = new ArrayList();

    public void addConverterInterceptor(ConverterInterceptor pvConverterInterceptor) {
        if (pvConverterInterceptor == null) {
            throw new IllegalArgumentException("The ConverterInterceptor must be different from null");
        }
        this.interceptors.remove(pvConverterInterceptor);
        this.interceptors.add(pvConverterInterceptor);
    }

    public ConverterInterceptor getConverterInterceptorByPosition(int pvPosition) {
        return (ConverterInterceptor)this.interceptors.get(pvPosition);
    }

    public void removeConverterInterceptor(ConverterInterceptor pvSearchInterceptor) {
        this.interceptors.remove(pvSearchInterceptor);
    }

    public int size() {
        return this.interceptors.size();
    }

    public void clear() {
        this.interceptors.clear();
    }

    public Object fireBeforeConvert(Object pvConvertObject, Class pvToType) {
        Object lvReturn = pvConvertObject;
        Iterator iter = this.interceptors.iterator();
        while (iter.hasNext()) {
            ConverterInterceptor lvInterceptor = (ConverterInterceptor)iter.next();
            lvReturn = lvInterceptor.beforeConvert(pvConvertObject, pvToType);
        }
        return lvReturn;
    }

    public Object fireAfterConvert(Object pvResult, Class pvToType) {
        Object lvReturn = pvResult;
        Iterator iter = this.interceptors.iterator();
        while (iter.hasNext()) {
            ConverterInterceptor lvInterceptor = (ConverterInterceptor)iter.next();
            lvReturn = lvInterceptor.afterConvert(pvResult, pvToType);
        }
        return lvReturn;
    }

    public void fireOnError(Exception pvException) {
        Iterator iter = this.interceptors.iterator();
        while (iter.hasNext()) {
            ConverterInterceptor lvInterceptor = (ConverterInterceptor)iter.next();
            lvInterceptor.onError(pvException);
        }
    }

    public void fireBeforeConvertRecursion(ConversionContext pvContext) {
        Iterator iter = this.interceptors.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof ConverterInterceptorRecursive)) continue;
            ConverterInterceptorRecursive lvInterceptor = (ConverterInterceptorRecursive)o;
            lvInterceptor.beforeConvertRecursion(pvContext);
        }
    }

    public void fireAfterConvertRecursion(ConversionContext pvContext) {
        Iterator iter = this.interceptors.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof ConverterInterceptorRecursive)) continue;
            ConverterInterceptorRecursive lvInterceptor = (ConverterInterceptorRecursive)o;
            lvInterceptor.afterConvertRecursion(pvContext);
        }
    }
}

