/*
 * Decompiled with CFR 0.152.
 */
package javax.speech;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.speech.EngineCentral;
import javax.speech.EngineCreate;
import javax.speech.EngineException;
import javax.speech.EngineList;
import javax.speech.EngineModeDesc;
import javax.speech.recognition.Recognizer;
import javax.speech.recognition.RecognizerModeDesc;
import javax.speech.synthesis.Synthesizer;
import javax.speech.synthesis.SynthesizerModeDesc;

public class Central {
    private static boolean loadedProperties = false;
    private static Hashtable centralList = new Hashtable();
    private static Recognizer lastRecognizer = null;
    private static Synthesizer lastSynthesizer = null;

    public static final synchronized EngineList availableRecognizers(EngineModeDesc engineModeDesc) throws SecurityException {
        if (engineModeDesc == null) {
            engineModeDesc = new RecognizerModeDesc();
        } else if (!(engineModeDesc instanceof RecognizerModeDesc)) {
            engineModeDesc = new RecognizerModeDesc(engineModeDesc.getEngineName(), engineModeDesc.getModeName(), engineModeDesc.getLocale(), engineModeDesc.getRunning(), null, null);
        }
        Central.loadProps();
        EngineList engineList = new EngineList();
        Enumeration enumeration = centralList.elements();
        while (enumeration.hasMoreElements()) {
            EngineCentral engineCentral = (EngineCentral)enumeration.nextElement();
            EngineList engineList2 = engineCentral.createEngineList(engineModeDesc);
            if (engineList2 == null) continue;
            int n = 0;
            while (n < engineList2.size()) {
                if (engineList2.elementAt(n) instanceof RecognizerModeDesc && engineList2.elementAt(n) instanceof EngineCreate) {
                    engineList.addElement(engineList2.elementAt(n));
                }
                ++n;
            }
        }
        return engineList;
    }

    public static final synchronized EngineList availableSynthesizers(EngineModeDesc engineModeDesc) throws SecurityException {
        if (engineModeDesc == null) {
            engineModeDesc = new SynthesizerModeDesc();
        } else if (!(engineModeDesc instanceof SynthesizerModeDesc)) {
            engineModeDesc = new SynthesizerModeDesc(engineModeDesc.getEngineName(), engineModeDesc.getModeName(), engineModeDesc.getLocale(), engineModeDesc.getRunning(), null);
        }
        Central.loadProps();
        EngineList engineList = new EngineList();
        Enumeration enumeration = centralList.elements();
        while (enumeration.hasMoreElements()) {
            EngineCentral engineCentral = (EngineCentral)enumeration.nextElement();
            EngineList engineList2 = engineCentral.createEngineList(engineModeDesc);
            if (engineList2 == null) continue;
            int n = 0;
            while (n < engineList2.size()) {
                if (engineList2.elementAt(n) instanceof SynthesizerModeDesc && engineList2.elementAt(n) instanceof EngineCreate) {
                    engineList.addElement(engineList2.elementAt(n));
                }
                ++n;
            }
        }
        return engineList;
    }

    public static final synchronized Recognizer createRecognizer(EngineModeDesc engineModeDesc) throws IllegalArgumentException, EngineException, SecurityException {
        if (engineModeDesc == null) {
            engineModeDesc = new RecognizerModeDesc();
        }
        if (engineModeDesc instanceof EngineCreate) {
            EngineCreate engineCreate = (EngineCreate)((Object)engineModeDesc);
            return (Recognizer)engineCreate.createEngine();
        }
        boolean bl = false;
        String string = Locale.getDefault().getLanguage();
        String string2 = Locale.getDefault().getCountry();
        if (engineModeDesc.getLocale() == null) {
            engineModeDesc.setLocale(new Locale(string, ""));
            bl = true;
        }
        if (lastRecognizer != null && lastRecognizer.getEngineModeDesc().match(engineModeDesc)) {
            if (bl) {
                engineModeDesc.setLocale(null);
            }
            return lastRecognizer;
        }
        EngineList engineList = Central.availableRecognizers(engineModeDesc);
        if (engineList.isEmpty()) {
            return null;
        }
        if (bl) {
            engineModeDesc.setLocale(null);
        }
        if (bl) {
            engineList.orderByMatch(new EngineModeDesc(new Locale(string, string2)));
        }
        if (engineModeDesc.getRunning() == null) {
            EngineModeDesc engineModeDesc2 = new EngineModeDesc();
            engineModeDesc2.setRunning(Boolean.TRUE);
            engineList.orderByMatch(engineModeDesc2);
        }
        int n = 0;
        while (n < engineList.size()) {
            try {
                Recognizer recognizer;
                EngineCreate engineCreate = (EngineCreate)engineList.elementAt(n);
                lastRecognizer = recognizer = (Recognizer)engineCreate.createEngine();
                return recognizer;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (EngineException engineException) {}
            ++n;
        }
        return null;
    }

    public static final synchronized Synthesizer createSynthesizer(EngineModeDesc engineModeDesc) throws IllegalArgumentException, EngineException {
        if (engineModeDesc == null) {
            engineModeDesc = new SynthesizerModeDesc();
        }
        if (engineModeDesc instanceof EngineCreate) {
            EngineCreate engineCreate = (EngineCreate)((Object)engineModeDesc);
            return (Synthesizer)engineCreate.createEngine();
        }
        boolean bl = false;
        String string = Locale.getDefault().getLanguage();
        String string2 = Locale.getDefault().getCountry();
        if (engineModeDesc.getLocale() == null) {
            engineModeDesc.setLocale(new Locale(string, ""));
            bl = true;
        }
        if (lastSynthesizer != null && lastSynthesizer.getEngineModeDesc().match(engineModeDesc)) {
            if (bl) {
                engineModeDesc.setLocale(null);
            }
            return lastSynthesizer;
        }
        EngineList engineList = Central.availableSynthesizers(engineModeDesc);
        if (engineList.isEmpty()) {
            return null;
        }
        if (bl) {
            engineModeDesc.setLocale(null);
        }
        if (bl) {
            engineList.orderByMatch(new EngineModeDesc(new Locale(string, string2)));
        }
        if (engineModeDesc.getRunning() == null) {
            EngineModeDesc engineModeDesc2 = new EngineModeDesc();
            engineModeDesc2.setRunning(Boolean.TRUE);
            engineList.orderByMatch(engineModeDesc2);
        }
        int n = 0;
        while (n < engineList.size()) {
            try {
                Synthesizer synthesizer;
                EngineCreate engineCreate = (EngineCreate)engineList.elementAt(n);
                lastSynthesizer = synthesizer = (Synthesizer)engineCreate.createEngine();
                return synthesizer;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (EngineException engineException) {}
            ++n;
        }
        return null;
    }

    private static final synchronized void loadProps() {
        if (loadedProperties) {
            return;
        }
        loadedProperties = true;
        String string = File.separator;
        String[] stringArray = new String[]{String.valueOf(System.getProperty("user.home")) + string + "speech.properties", String.valueOf(System.getProperty("java.home")) + string + "lib" + string + "speech.properties"};
        int n = 0;
        while (n < stringArray.length) {
            Object object;
            String string2 = stringArray[n];
            Properties properties = new Properties();
            File file = new File(string2);
            try {
                object = new FileInputStream(file);
                properties.load(new BufferedInputStream((InputStream)object));
                ((FileInputStream)object).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
            object = properties.propertyNames();
            while (object.hasMoreElements()) {
                String string3 = (String)object.nextElement();
                if (!string3.endsWith("EngineCentral")) continue;
                String string4 = properties.getProperty(string3);
                try {
                    Central.registerEngineCentral(string4);
                }
                catch (EngineException engineException) {}
            }
            ++n;
        }
    }

    public static final synchronized void registerEngineCentral(String string) throws EngineException {
        Class<?> clazz;
        if (centralList.containsKey(string)) {
            return;
        }
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new EngineException("javax.speech.Central: no class found for " + string);
        }
        try {
            EngineCentral engineCentral = (EngineCentral)clazz.newInstance();
            centralList.put(string, engineCentral);
        }
        catch (Exception exception) {
            throw new EngineException("javax.speech.Central: error creating EngineCentral from " + string);
        }
    }
}

