/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.parser;

public final class SmcMessage {
    private final String _name;
    private final int _lineNumber;
    private final int _level;
    private final String _text;
    public static final int WARNING = 0;
    public static final int ERROR = 1;

    public SmcMessage(String name, int lineNumber, int level, String text) {
        if (name == null) {
            throw new NullPointerException("null name");
        }
        if (text == null) {
            throw new NullPointerException("null text");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("empty name");
        }
        if (lineNumber < 0) {
            throw new IllegalArgumentException("negative lineNumber");
        }
        if (level != 0 && level != 1) {
            throw new IllegalArgumentException("invalid level (" + Integer.toString(level) + ")");
        }
        if (text.length() == 0) {
            throw new IllegalArgumentException("empty text");
        }
        this._name = name;
        this._lineNumber = lineNumber;
        this._level = level;
        this._text = text;
    }

    public String getName() {
        return this._name;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public int getLevel() {
        return this._level;
    }

    public String getText() {
        return this._text;
    }
}

