/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class SQLConnect
extends StyleElement {
    Expression database;
    Expression driver;
    Expression user;
    Expression password;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainTemplateBody() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        String string = this.attributeList.getValue("database");
        if (string == null) {
            this.reportAbsence("database");
            string = "";
        }
        this.database = this.makeAttributeValueTemplate(string);
        String string2 = this.attributeList.getValue("driver");
        if (string2 == null) {
            if (string.length() > 9 && string.substring(0, 9).equals("jdbc:odbc")) {
                string2 = "sun.jdbc.odbc.JdbcOdbcDriver";
            } else {
                this.reportAbsence("driver");
            }
        }
        this.driver = this.makeAttributeValueTemplate(string2);
        String string3 = this.attributeList.getValue("user");
        this.user = string3 == null ? StringValue.EMPTY_STRING : this.makeAttributeValueTemplate(string3);
        String string4 = this.attributeList.getValue("password");
        this.password = string4 == null ? StringValue.EMPTY_STRING : this.makeAttributeValueTemplate(string4);
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        this.database = this.typeCheck("database", this.database);
        this.driver = this.typeCheck("driver", this.driver);
        this.user = this.typeCheck("user", this.user);
        this.password = this.typeCheck("password", this.password);
    }

    public Instruction compile() throws TransformerConfigurationException {
        ConnectInstruction connectInstruction = new ConnectInstruction(this.database, this.driver, this.user, this.password);
        return connectInstruction;
    }

    private static class ConnectInstruction
    extends Instruction {
        Expression database;
        Expression driver;
        Expression user;
        Expression password;

        public ConnectInstruction(Expression expression, Expression expression2, Expression expression3, Expression expression4) {
            this.database = expression;
            this.driver = expression2;
            this.user = expression3;
            this.password = expression4;
        }

        public void setInstructionDetails(Controller controller, NamePool namePool, InstructionDetails instructionDetails) {
            instructionDetails.setInstructionName("connect");
            instructionDetails.setProperty("instruction-namespace", (Object)"java:/net.sf.saxon.sql.SQLElementFactory");
        }

        public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
            Connection connection = null;
            String string = this.database.evaluateAsString(xPathContext);
            String string2 = this.driver.evaluateAsString(xPathContext);
            String string3 = this.user.evaluateAsString(xPathContext);
            String string4 = this.password.evaluateAsString(xPathContext);
            try {
                Class.forName(string2);
                connection = DriverManager.getConnection(string, string3, string4);
            }
            catch (Exception exception) {
                throw new TransformerException("JDBC Connection Failure: " + exception.getMessage());
            }
            Controller controller = xPathContext.getController();
            controller.getReceiver().append((Item)new ObjectValue((Object)connection));
            return null;
        }
    }
}

