/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sql;

import java.sql.Connection;
import java.sql.SQLException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.value.ObjectValue;

public class SQLClose
extends StyleElement {
    Expression connection = null;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainTemplateBody() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        String string = this.getAttribute("connection");
        if (string == null) {
            this.reportAbsence("connection");
        } else {
            this.connection = this.makeExpression(string);
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        this.connection = this.typeCheck("connection", this.connection);
    }

    public Instruction compile() throws TransformerConfigurationException {
        CloseInstruction closeInstruction = new CloseInstruction(this.connection);
        return closeInstruction;
    }

    private static class CloseInstruction
    extends Instruction {
        private Expression connectExpression;

        public CloseInstruction(Expression expression) {
            this.connectExpression = expression;
        }

        public void setInstructionDetails(Controller controller, NamePool namePool, InstructionDetails instructionDetails) {
            instructionDetails.setInstructionName("close");
            instructionDetails.setProperty("instruction-namespace", (Object)"java:/net.sf.saxon.sql.SQLElementFactory");
        }

        public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
            Controller controller = xPathContext.getController();
            Item item = this.connectExpression.evaluateItem(xPathContext);
            if (!(item instanceof ObjectValue) || !(((ObjectValue)item).getObject() instanceof Connection)) {
                throw new TransformerException("Value of connection expression is not a JDBC Connection");
            }
            Connection connection = (Connection)((ObjectValue)item).getObject();
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                throw this.styleError("(SQL) Failed to close connection: " + sQLException.getMessage(), controller);
            }
            return null;
        }
    }
}

