/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;
import proguard.io.RenamedDataEntry;
import proguard.io.WrappedDataEntry;
import proguard.util.StringMatcher;

public class RenamedParentDataEntryWriter
implements DataEntryWriter {
    private final StringMatcher matcher;
    private final String newParentName;
    private final DataEntryWriter dataEntryWriter;

    public RenamedParentDataEntryWriter(StringMatcher matcher, String newParentName, DataEntryWriter dataEntryWriter) {
        this.matcher = matcher;
        this.newParentName = newParentName;
        this.dataEntryWriter = dataEntryWriter;
    }

    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        return this.dataEntryWriter.createDirectory(this.getRedirectedEntry(dataEntry));
    }

    public boolean sameOutputStream(DataEntry dataEntry1, DataEntry dataEntry2) throws IOException {
        return this.dataEntryWriter.sameOutputStream(this.getRedirectedEntry(dataEntry1), this.getRedirectedEntry(dataEntry2));
    }

    public OutputStream createOutputStream(DataEntry dataEntry) throws IOException {
        return this.dataEntryWriter.createOutputStream(this.getRedirectedEntry(dataEntry));
    }

    public void close() throws IOException {
        this.dataEntryWriter.close();
    }

    public void println(PrintWriter pw, String prefix) {
        this.dataEntryWriter.println(pw, prefix);
    }

    private DataEntry getRedirectedEntry(DataEntry dataEntry) {
        if (dataEntry == null) {
            return null;
        }
        DataEntry parentEntry = dataEntry.getParent();
        if (parentEntry != null && this.matcher.matches(parentEntry.getName())) {
            final RenamedDataEntry renamedParentEntry = new RenamedDataEntry(parentEntry, this.newParentName);
            return new WrappedDataEntry(dataEntry){

                public DataEntry getParent() {
                    return renamedParentEntry;
                }
            };
        }
        return dataEntry;
    }
}

