/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.evaluation.SimplifiedInvocationUnit;
import proguard.evaluation.Stack;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TracedReferenceValue;
import proguard.evaluation.value.Value;

public class ReferenceTracingInvocationUnit
extends SimplifiedInvocationUnit {
    private final SimplifiedInvocationUnit invocationUnit;
    private int offset;

    public ReferenceTracingInvocationUnit(SimplifiedInvocationUnit invocationUnit) {
        this.invocationUnit = invocationUnit;
    }

    public void enterExceptionHandler(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, int catchType, Stack stack) {
        this.offset = offset;
        super.enterExceptionHandler(clazz, method, codeAttribute, offset, catchType, stack);
    }

    public void invokeMember(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction, Stack stack) {
        this.offset = offset;
        super.invokeMember(clazz, method, codeAttribute, offset, constantInstruction, stack);
    }

    public Value getExceptionValue(Clazz clazz, ClassConstant catchClassConstant) {
        return this.trace(this.invocationUnit.getExceptionValue(clazz, catchClassConstant), this.offset | 0x20000000);
    }

    public void setFieldClassValue(Clazz clazz, RefConstant refConstant, ReferenceValue value) {
        this.invocationUnit.setFieldClassValue(clazz, refConstant, value);
    }

    public Value getFieldClassValue(Clazz clazz, RefConstant refConstant, String type) {
        return this.trace(this.invocationUnit.getFieldClassValue(clazz, refConstant, type), this.offset | 0x4000000);
    }

    public void setFieldValue(Clazz clazz, RefConstant refConstant, Value value) {
        this.invocationUnit.setFieldValue(clazz, refConstant, value);
    }

    public Value getFieldValue(Clazz clazz, RefConstant refConstant, String type) {
        return this.trace(this.invocationUnit.getFieldValue(clazz, refConstant, type), this.offset | 0x4000000);
    }

    public void setMethodParameterValue(Clazz clazz, RefConstant refConstant, int parameterIndex, Value value) {
        this.invocationUnit.setMethodParameterValue(clazz, refConstant, parameterIndex, value);
    }

    public Value getMethodParameterValue(Clazz clazz, Method method, int parameterIndex, String type, Clazz referencedClass) {
        Value parameterValue = this.invocationUnit.getMethodParameterValue(clazz, method, parameterIndex, type, referencedClass);
        return this.trace(parameterValue, parameterIndex | 0x1000000);
    }

    public void setMethodReturnValue(Clazz clazz, Method method, Value value) {
        this.invocationUnit.setMethodReturnValue(clazz, method, value);
    }

    public Value getMethodReturnValue(Clazz clazz, RefConstant refConstant, String type) {
        Value returnValue = this.invocationUnit.getMethodReturnValue(clazz, refConstant, type);
        return this.trace(returnValue, this.offset | 0x2000000);
    }

    public Value getMethodReturnValue(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant, String type) {
        Value returnValue = this.invocationUnit.getMethodReturnValue(clazz, invokeDynamicConstant, type);
        return this.trace(returnValue, this.offset | 0x2000000);
    }

    protected Value trace(Value value, int trace) {
        if (value.computationalType() != 5) {
            return value;
        }
        return this.trace(value, new InstructionOffsetValue(trace));
    }

    protected Value trace(Value value, InstructionOffsetValue traceValue) {
        return new TracedReferenceValue(this.untrace(value).referenceValue(), traceValue);
    }

    private Value untrace(Value value) {
        return value instanceof TracedReferenceValue ? ((TracedReferenceValue)value).getReferenceValue() : value;
    }
}

