/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ParticularDoubleValue;
import proguard.evaluation.value.ParticularFloatValue;
import proguard.evaluation.value.ParticularLongValue;
import proguard.evaluation.value.SpecificIntegerValue;

final class ParticularIntegerValue
extends SpecificIntegerValue {
    private final int value;

    public ParticularIntegerValue(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public IntegerValue negate() {
        return new ParticularIntegerValue(-this.value);
    }

    public IntegerValue convertToByte() {
        byte byteValue = (byte)this.value;
        return byteValue == this.value ? this : new ParticularIntegerValue(byteValue);
    }

    public IntegerValue convertToCharacter() {
        char charValue = (char)this.value;
        return charValue == this.value ? this : new ParticularIntegerValue(charValue);
    }

    public IntegerValue convertToShort() {
        short shortValue = (short)this.value;
        return shortValue == this.value ? this : new ParticularIntegerValue(shortValue);
    }

    public LongValue convertToLong() {
        return new ParticularLongValue(this.value);
    }

    public FloatValue convertToFloat() {
        return new ParticularFloatValue(this.value);
    }

    public DoubleValue convertToDouble() {
        return new ParticularDoubleValue(this.value);
    }

    public IntegerValue generalize(IntegerValue other) {
        return other.generalize(this);
    }

    public IntegerValue add(IntegerValue other) {
        return other.add(this);
    }

    public IntegerValue subtract(IntegerValue other) {
        return other.subtractFrom(this);
    }

    public IntegerValue subtractFrom(IntegerValue other) {
        return other.subtract(this);
    }

    public IntegerValue multiply(IntegerValue other) {
        return other.multiply(this);
    }

    public IntegerValue divide(IntegerValue other) throws ArithmeticException {
        return other.divideOf(this);
    }

    public IntegerValue divideOf(IntegerValue other) throws ArithmeticException {
        return other.divide(this);
    }

    public IntegerValue remainder(IntegerValue other) throws ArithmeticException {
        return other.remainderOf(this);
    }

    public IntegerValue remainderOf(IntegerValue other) throws ArithmeticException {
        return other.remainder(this);
    }

    public IntegerValue shiftLeft(IntegerValue other) {
        return other.shiftLeftOf(this);
    }

    public IntegerValue shiftLeftOf(IntegerValue other) {
        return other.shiftLeft(this);
    }

    public IntegerValue shiftRight(IntegerValue other) {
        return other.shiftRightOf(this);
    }

    public IntegerValue shiftRightOf(IntegerValue other) {
        return other.shiftRight(this);
    }

    public IntegerValue unsignedShiftRight(IntegerValue other) {
        return other.unsignedShiftRightOf(this);
    }

    public IntegerValue unsignedShiftRightOf(IntegerValue other) {
        return other.unsignedShiftRight(this);
    }

    public LongValue shiftLeftOf(LongValue other) {
        return other.shiftLeft(this);
    }

    public LongValue shiftRightOf(LongValue other) {
        return other.shiftRight(this);
    }

    public LongValue unsignedShiftRightOf(LongValue other) {
        return other.unsignedShiftRight(this);
    }

    public IntegerValue and(IntegerValue other) {
        return other.and(this);
    }

    public IntegerValue or(IntegerValue other) {
        return other.or(this);
    }

    public IntegerValue xor(IntegerValue other) {
        return other.xor(this);
    }

    public int equal(IntegerValue other) {
        return other.equal(this);
    }

    public int lessThan(IntegerValue other) {
        return other.greaterThan(this);
    }

    public int lessThanOrEqual(IntegerValue other) {
        return other.greaterThanOrEqual(this);
    }

    public IntegerValue generalize(ParticularIntegerValue other) {
        return this.generalize((SpecificIntegerValue)other);
    }

    public IntegerValue add(ParticularIntegerValue other) {
        return new ParticularIntegerValue(this.value + other.value);
    }

    public IntegerValue subtract(ParticularIntegerValue other) {
        return new ParticularIntegerValue(this.value - other.value);
    }

    public IntegerValue subtractFrom(ParticularIntegerValue other) {
        return new ParticularIntegerValue(other.value - this.value);
    }

    public IntegerValue multiply(ParticularIntegerValue other) {
        return new ParticularIntegerValue(this.value * other.value);
    }

    public IntegerValue divide(ParticularIntegerValue other) throws ArithmeticException {
        return new ParticularIntegerValue(this.value / other.value);
    }

    public IntegerValue divideOf(ParticularIntegerValue other) throws ArithmeticException {
        return new ParticularIntegerValue(other.value / this.value);
    }

    public IntegerValue remainder(ParticularIntegerValue other) throws ArithmeticException {
        return new ParticularIntegerValue(this.value % other.value);
    }

    public IntegerValue remainderOf(ParticularIntegerValue other) throws ArithmeticException {
        return new ParticularIntegerValue(other.value % this.value);
    }

    public IntegerValue shiftLeft(ParticularIntegerValue other) {
        return new ParticularIntegerValue(this.value << other.value);
    }

    public IntegerValue shiftRight(ParticularIntegerValue other) {
        return new ParticularIntegerValue(this.value >> other.value);
    }

    public IntegerValue unsignedShiftRight(ParticularIntegerValue other) {
        return new ParticularIntegerValue(this.value >>> other.value);
    }

    public IntegerValue shiftLeftOf(ParticularIntegerValue other) {
        return new ParticularIntegerValue(other.value << this.value);
    }

    public IntegerValue shiftRightOf(ParticularIntegerValue other) {
        return new ParticularIntegerValue(other.value >> this.value);
    }

    public IntegerValue unsignedShiftRightOf(ParticularIntegerValue other) {
        return new ParticularIntegerValue(other.value >>> this.value);
    }

    public LongValue shiftLeftOf(ParticularLongValue other) {
        return new ParticularLongValue(other.value() << this.value);
    }

    public LongValue shiftRightOf(ParticularLongValue other) {
        return new ParticularLongValue(other.value() >> this.value);
    }

    public LongValue unsignedShiftRightOf(ParticularLongValue other) {
        return new ParticularLongValue(other.value() >>> this.value);
    }

    public IntegerValue and(ParticularIntegerValue other) {
        return new ParticularIntegerValue(this.value & other.value);
    }

    public IntegerValue or(ParticularIntegerValue other) {
        return new ParticularIntegerValue(this.value | other.value);
    }

    public IntegerValue xor(ParticularIntegerValue other) {
        return new ParticularIntegerValue(this.value ^ other.value);
    }

    public int equal(ParticularIntegerValue other) {
        return this.value == other.value ? 1 : -1;
    }

    public int lessThan(ParticularIntegerValue other) {
        return this.value < other.value ? 1 : -1;
    }

    public int lessThanOrEqual(ParticularIntegerValue other) {
        return this.value <= other.value ? 1 : -1;
    }

    public boolean isParticular() {
        return true;
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.value == ((ParticularIntegerValue)object).value;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }
}

