/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.evaluation.BranchTargetFinder;

public class GotoCommonCodeReplacer
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor {
    private static final boolean DEBUG = false;
    private final InstructionVisitor extraInstructionVisitor;
    private final BranchTargetFinder branchTargetFinder = new BranchTargetFinder();
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(true, false);

    public GotoCommonCodeReplacer(InstructionVisitor extraInstructionVisitor) {
        this.extraInstructionVisitor = extraInstructionVisitor;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.branchTargetFinder.visitCodeAttribute(clazz, method, codeAttribute);
        this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
        codeAttribute.instructionsAccept(clazz, method, this);
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        int branchOffset;
        int targetOffset;
        int commonCount;
        byte opcode = branchInstruction.opcode;
        if (!(opcode != -89 && opcode != -56 || this.branchTargetFinder.isBranchTarget(offset) || (commonCount = this.commonByteCodeCount(codeAttribute, offset, targetOffset = offset + (branchOffset = branchInstruction.branchOffset))) <= 0 || this.exceptionBoundary(codeAttribute, offset, targetOffset))) {
            for (int delta = 0; delta <= commonCount; ++delta) {
                int deleteOffset = offset - delta;
                if (!this.branchTargetFinder.isInstruction(deleteOffset)) continue;
                this.codeAttributeEditor.clearModifications(deleteOffset);
                this.codeAttributeEditor.deleteInstruction(deleteOffset);
            }
            int newBranchOffset = branchOffset - commonCount;
            if (newBranchOffset != branchInstruction.length(offset)) {
                Instruction newGotoInstruction = new BranchInstruction(opcode, newBranchOffset).shrink();
                this.codeAttributeEditor.replaceInstruction(offset, newGotoInstruction);
            }
            if (this.extraInstructionVisitor != null) {
                this.extraInstructionVisitor.visitBranchInstruction(clazz, method, codeAttribute, offset, branchInstruction);
            }
        }
    }

    private int commonByteCodeCount(CodeAttribute codeAttribute, int offset1, int offset2) {
        int newOffset2;
        int newOffset1;
        byte[] code = codeAttribute.code;
        int successfulDelta = 0;
        for (int delta = 1; delta <= offset1 && delta <= offset2 && offset2 - delta != offset1 && code[newOffset1 = offset1 - delta] == code[newOffset2 = offset2 - delta] && !(this.branchTargetFinder.isInstruction(newOffset1) ^ this.branchTargetFinder.isInstruction(newOffset2)); ++delta) {
            if (!this.branchTargetFinder.isInstruction(newOffset1) || !this.branchTargetFinder.isInstruction(newOffset2)) continue;
            if (this.branchTargetFinder.isBranchOrigin(newOffset1) || this.branchTargetFinder.isBranchTarget(newOffset1) || this.branchTargetFinder.isExceptionStart(newOffset1) || this.branchTargetFinder.isExceptionEnd(newOffset1) || this.branchTargetFinder.isInitializer(newOffset1) || this.branchTargetFinder.isExceptionStart(newOffset2) || this.branchTargetFinder.isExceptionEnd(newOffset2) || this.isPop(code[newOffset1])) break;
            if (this.branchTargetFinder.isBranchTarget(newOffset2)) {
                successfulDelta = delta;
            }
            if (this.branchTargetFinder.isBranchTarget(newOffset1)) break;
        }
        return successfulDelta;
    }

    private boolean isPop(byte opcode) {
        return opcode == 87 || opcode == 88 || opcode == -66;
    }

    private boolean exceptionBoundary(CodeAttribute codeAttribute, int offset1, int offset2) {
        int offset;
        if (offset2 < offset1) {
            offset = offset1;
            offset1 = offset2;
            offset2 = offset;
        }
        for (offset = offset1; offset <= offset2; ++offset) {
            if (!this.branchTargetFinder.isExceptionStart(offset) && !this.branchTargetFinder.isExceptionEnd(offset)) continue;
            return true;
        }
        return false;
    }
}

