/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import proguard.io.DataEntry;

public class ZipDataEntry
implements DataEntry {
    private final DataEntry parent;
    private final ZipEntry zipEntry;
    private ZipInputStream zipInputStream;
    private InputStream bufferedInputStream;

    public ZipDataEntry(DataEntry parent, ZipEntry zipEntry, ZipInputStream zipInputStream) {
        this.parent = parent;
        this.zipEntry = zipEntry;
        this.zipInputStream = zipInputStream;
    }

    public String getName() {
        String name = this.zipEntry.getName().replace(File.separatorChar, '/');
        int length = name.length();
        return length > 0 && name.charAt(length - 1) == '/' ? name.substring(0, length - 1) : name;
    }

    public boolean isDirectory() {
        return this.zipEntry.isDirectory();
    }

    public InputStream getInputStream() throws IOException {
        if (this.bufferedInputStream == null) {
            this.bufferedInputStream = new BufferedInputStream(this.zipInputStream);
        }
        return this.bufferedInputStream;
    }

    public void closeInputStream() throws IOException {
        this.zipInputStream.closeEntry();
        this.zipInputStream = null;
        this.bufferedInputStream = null;
    }

    public DataEntry getParent() {
        return this.parent;
    }

    public String toString() {
        return this.parent.toString() + ':' + this.getName();
    }
}

