/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.util.List;
import proguard.ClassSpecification;
import proguard.KeepClassSpecification;
import proguard.MemberSpecification;
import proguard.classfile.attribute.annotation.visitor.AllAnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.AnnotatedClassVisitor;
import proguard.classfile.attribute.annotation.visitor.AnnotationToMemberVisitor;
import proguard.classfile.attribute.annotation.visitor.AnnotationTypeFilter;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.visitor.AllClassVisitor;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassHierarchyTraveler;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberDescriptorFilter;
import proguard.classfile.visitor.MemberDescriptorReferencedClassVisitor;
import proguard.classfile.visitor.MemberNameFilter;
import proguard.classfile.visitor.MemberToClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassPoolVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.classfile.visitor.NamedClassVisitor;
import proguard.classfile.visitor.NamedFieldVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;

public class ClassSpecificationVisitorFactory {
    public static ClassPoolVisitor createClassPoolVisitor(List keepClassSpecifications, ClassVisitor classVisitor, MemberVisitor memberVisitor, boolean shrinking, boolean optimizing, boolean obfuscating) {
        MultiClassPoolVisitor multiClassPoolVisitor = new MultiClassPoolVisitor();
        if (keepClassSpecifications != null) {
            for (int index = 0; index < keepClassSpecifications.size(); ++index) {
                KeepClassSpecification keepClassSpecification = (KeepClassSpecification)keepClassSpecifications.get(index);
                if (!(shrinking && !keepClassSpecification.allowShrinking || optimizing && !keepClassSpecification.allowOptimization) && (!obfuscating || keepClassSpecification.allowObfuscation)) continue;
                multiClassPoolVisitor.addClassPoolVisitor(ClassSpecificationVisitorFactory.createClassPoolVisitor(keepClassSpecification, classVisitor, memberVisitor));
            }
        }
        return multiClassPoolVisitor;
    }

    public static ClassPoolVisitor createClassPoolVisitor(List classSpecifications, ClassVisitor classVisitor, MemberVisitor memberVisitor) {
        MultiClassPoolVisitor multiClassPoolVisitor = new MultiClassPoolVisitor();
        if (classSpecifications != null) {
            for (int index = 0; index < classSpecifications.size(); ++index) {
                ClassSpecification classSpecification = (ClassSpecification)classSpecifications.get(index);
                multiClassPoolVisitor.addClassPoolVisitor(ClassSpecificationVisitorFactory.createClassPoolVisitor(classSpecification, classVisitor, memberVisitor));
            }
        }
        return multiClassPoolVisitor;
    }

    public static ClassPoolVisitor createClassPoolVisitor(KeepClassSpecification keepClassSpecification, ClassVisitor classVisitor, MemberVisitor memberVisitor) {
        if (keepClassSpecification.markDescriptorClasses && classVisitor != null) {
            MemberVisitor memberVisitor2 = memberVisitor = memberVisitor == null ? new MemberDescriptorReferencedClassVisitor(classVisitor) : new MultiMemberVisitor(new MemberVisitor[]{memberVisitor, new MemberDescriptorReferencedClassVisitor(classVisitor)});
        }
        if (!keepClassSpecification.markClasses && !keepClassSpecification.markConditionally) {
            classVisitor = null;
        }
        if (keepClassSpecification.markConditionally) {
            ClassVisitor composedClassVisitor = ClassSpecificationVisitorFactory.createCombinedClassVisitor(keepClassSpecification, classVisitor, memberVisitor);
            classVisitor = ClassSpecificationVisitorFactory.createClassMemberTester(keepClassSpecification, composedClassVisitor);
            memberVisitor = null;
        }
        return ClassSpecificationVisitorFactory.createClassPoolVisitor((ClassSpecification)keepClassSpecification, classVisitor, memberVisitor);
    }

    public static ClassPoolVisitor createClassPoolVisitor(ClassSpecification classSpecification, ClassVisitor classVisitor, MemberVisitor memberVisitor) {
        String annotationType;
        ClassVisitor composedClassVisitor = ClassSpecificationVisitorFactory.createCombinedClassVisitor(classSpecification, classVisitor, memberVisitor);
        String className = classSpecification.className;
        String extendsAnnotationType = classSpecification.extendsAnnotationType;
        String extendsClassName = classSpecification.extendsClassName;
        if (className != null && (extendsAnnotationType != null || extendsClassName != null || ClassSpecificationVisitorFactory.containsWildCards(className))) {
            composedClassVisitor = new ClassNameFilter(className, composedClassVisitor);
            className = null;
        }
        if ((annotationType = classSpecification.annotationType) != null) {
            composedClassVisitor = new AllAttributeVisitor(new AllAnnotationVisitor(new AnnotationTypeFilter(annotationType, new AnnotatedClassVisitor(composedClassVisitor))));
        }
        if (classSpecification.requiredSetAccessFlags != 0 || classSpecification.requiredUnsetAccessFlags != 0) {
            composedClassVisitor = new ClassAccessFilter(classSpecification.requiredSetAccessFlags, classSpecification.requiredUnsetAccessFlags, composedClassVisitor);
        }
        if (extendsAnnotationType != null || extendsClassName != null) {
            composedClassVisitor = new ClassHierarchyTraveler(false, false, false, true, composedClassVisitor);
            if (extendsAnnotationType != null) {
                composedClassVisitor = new AllAttributeVisitor(new AllAnnotationVisitor(new AnnotationTypeFilter(extendsAnnotationType, new AnnotatedClassVisitor(composedClassVisitor))));
            }
            if (extendsClassName != null) {
                if (ClassSpecificationVisitorFactory.containsWildCards(extendsClassName)) {
                    composedClassVisitor = new ClassNameFilter(extendsClassName, composedClassVisitor);
                } else {
                    className = extendsClassName;
                }
            }
        }
        return className != null ? new NamedClassVisitor(composedClassVisitor, className) : new AllClassVisitor(composedClassVisitor);
    }

    private static ClassVisitor createCombinedClassVisitor(ClassSpecification classSpecification, ClassVisitor classVisitor, MemberVisitor memberVisitor) {
        if (classSpecification.fieldSpecifications == null && classSpecification.methodSpecifications == null) {
            memberVisitor = null;
        }
        MultiClassVisitor multiClassVisitor = new MultiClassVisitor();
        if (classVisitor != null) {
            if (memberVisitor == null) {
                return classVisitor;
            }
            multiClassVisitor.addClassVisitor(classVisitor);
        }
        if (memberVisitor != null) {
            ClassVisitor memberClassVisitor = ClassSpecificationVisitorFactory.createClassVisitor(classSpecification, memberVisitor);
            if (classVisitor == null) {
                return memberClassVisitor;
            }
            multiClassVisitor.addClassVisitor(memberClassVisitor);
        }
        return multiClassVisitor;
    }

    private static ClassVisitor createClassVisitor(ClassSpecification classSpecification, MemberVisitor memberVisitor) {
        MultiClassVisitor multiClassVisitor = new MultiClassVisitor();
        ClassSpecificationVisitorFactory.addMemberVisitors(classSpecification.fieldSpecifications, true, multiClassVisitor, memberVisitor);
        ClassSpecificationVisitorFactory.addMemberVisitors(classSpecification.methodSpecifications, false, multiClassVisitor, memberVisitor);
        return new ClassHierarchyTraveler(true, true, false, false, multiClassVisitor);
    }

    private static void addMemberVisitors(List memberSpecifications, boolean isField, MultiClassVisitor multiClassVisitor, MemberVisitor memberVisitor) {
        if (memberSpecifications != null) {
            for (int index = 0; index < memberSpecifications.size(); ++index) {
                MemberSpecification memberSpecification = (MemberSpecification)memberSpecifications.get(index);
                multiClassVisitor.addClassVisitor(ClassSpecificationVisitorFactory.createClassVisitor(memberSpecification, isField, memberVisitor));
            }
        }
    }

    private static ClassVisitor createClassMemberTester(ClassSpecification classSpecification, ClassVisitor classVisitor) {
        return ClassSpecificationVisitorFactory.createClassMemberTester(classSpecification.fieldSpecifications, true, ClassSpecificationVisitorFactory.createClassMemberTester(classSpecification.methodSpecifications, false, classVisitor));
    }

    private static ClassVisitor createClassMemberTester(List memberSpecifications, boolean isField, ClassVisitor classVisitor) {
        if (memberSpecifications != null) {
            for (int index = 0; index < memberSpecifications.size(); ++index) {
                MemberSpecification memberSpecification = (MemberSpecification)memberSpecifications.get(index);
                classVisitor = ClassSpecificationVisitorFactory.createClassVisitor(memberSpecification, isField, new MemberToClassVisitor(classVisitor));
            }
        }
        return classVisitor;
    }

    private static ClassVisitor createClassVisitor(MemberSpecification memberSpecification, boolean isField, MemberVisitor memberVisitor) {
        boolean fullySpecified;
        String name = memberSpecification.name;
        String descriptor = memberSpecification.descriptor;
        boolean bl = fullySpecified = name != null && descriptor != null && !ClassSpecificationVisitorFactory.containsWildCards(name) && !ClassSpecificationVisitorFactory.containsWildCards(descriptor);
        if (!fullySpecified) {
            if (descriptor != null) {
                memberVisitor = new MemberDescriptorFilter(descriptor, memberVisitor);
            }
            if (name != null) {
                memberVisitor = new MemberNameFilter(name, memberVisitor);
            }
        }
        if (memberSpecification.annotationType != null) {
            memberVisitor = new AllAttributeVisitor(new AllAnnotationVisitor(new AnnotationTypeFilter(memberSpecification.annotationType, new AnnotationToMemberVisitor(memberVisitor))));
        }
        if (memberSpecification.requiredSetAccessFlags != 0 || memberSpecification.requiredUnsetAccessFlags != 0) {
            memberVisitor = new MemberAccessFilter(memberSpecification.requiredSetAccessFlags, memberSpecification.requiredUnsetAccessFlags, memberVisitor);
        }
        return isField ? (fullySpecified ? new NamedFieldVisitor(name, descriptor, memberVisitor) : new AllFieldVisitor(memberVisitor)) : (fullySpecified ? new NamedMethodVisitor(name, descriptor, memberVisitor) : new AllMethodVisitor(memberVisitor));
    }

    private static boolean containsWildCards(String string) {
        return string != null && (string.indexOf(33) >= 0 || string.indexOf(42) >= 0 || string.indexOf(63) >= 0 || string.indexOf(37) >= 0 || string.indexOf(44) >= 0 || string.indexOf("///") >= 0);
    }
}

