/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.Configuration;
import proguard.DataEntryReaderFactory;
import proguard.DuplicateClassPrinter;
import proguard.classfile.ClassPool;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassPresenceFilter;
import proguard.io.ClassFilter;
import proguard.io.ClassReader;
import proguard.io.DataEntryReader;
import proguard.io.DirectoryPump;

public class InputReader {
    private final Configuration configuration;

    public InputReader(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool programClassPool, ClassPool libraryClassPool) throws IOException {
        int warningCount;
        int noteCount;
        if (this.configuration.programJars == null) {
            throw new IOException("The input is empty. You have to specify one or more '-injars' options");
        }
        this.checkInputOutput(this.configuration.libraryJars, this.configuration.programJars);
        this.checkInputOutput(this.configuration.programJars, this.configuration.programJars);
        WarningPrinter warningPrinter = new WarningPrinter(System.err, this.configuration.warn);
        WarningPrinter notePrinter = new WarningPrinter(System.out, this.configuration.note);
        DuplicateClassPrinter duplicateClassPrinter = new DuplicateClassPrinter(notePrinter);
        this.readInput("Reading program ", this.configuration.programJars, (DataEntryReader)new ClassFilter(new ClassReader(false, this.configuration.skipNonPublicLibraryClasses, this.configuration.skipNonPublicLibraryClassMembers, warningPrinter, new ClassPresenceFilter(programClassPool, duplicateClassPrinter, new ClassPoolFiller(programClassPool)))));
        if (programClassPool.size() == 0) {
            throw new IOException("The input doesn't contain any classes. Did you specify the proper '-injars' options?");
        }
        if (this.configuration.libraryJars != null) {
            this.readInput("Reading library ", this.configuration.libraryJars, (DataEntryReader)new ClassFilter(new ClassReader(true, this.configuration.skipNonPublicLibraryClasses, this.configuration.skipNonPublicLibraryClassMembers, warningPrinter, new ClassPresenceFilter(programClassPool, duplicateClassPrinter, new ClassPresenceFilter(libraryClassPool, duplicateClassPrinter, new ClassPoolFiller(libraryClassPool))))));
        }
        if ((noteCount = notePrinter.getWarningCount()) > 0) {
            System.err.println("Note: there were " + noteCount + " duplicate class definitions.");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#duplicateclass)");
        }
        if ((warningCount = warningPrinter.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + warningCount + " classes in incorrectly named files.");
            System.err.println("         You should make sure all file names correspond to their class names.");
            System.err.println("         The directory hierarchies must correspond to the package hierarchies.");
            System.err.println("         (http://proguard.sourceforge.net/manual/troubleshooting.html#unexpectedclass)");
            if (!this.configuration.ignoreWarnings) {
                System.err.println("         If you don't mind the mentioned classes not being written out,");
                System.err.println("         you could try your luck using the '-ignorewarnings' option.");
                throw new IOException("Please correct the above warnings first.");
            }
        }
    }

    private void checkInputOutput(ClassPath inputClassPath, ClassPath outputClassPath) throws IOException {
        if (inputClassPath == null || outputClassPath == null) {
            return;
        }
        for (int index1 = 0; index1 < inputClassPath.size(); ++index1) {
            ClassPathEntry entry1 = inputClassPath.get(index1);
            if (entry1.isOutput()) continue;
            for (int index2 = 0; index2 < outputClassPath.size(); ++index2) {
                ClassPathEntry entry2 = outputClassPath.get(index2);
                if (!entry2.isOutput() || !entry2.getName().equals(entry1.getName())) continue;
                throw new IOException("Input jars and output jars must be different [" + entry1.getName() + "]");
            }
        }
    }

    private void readInput(String messagePrefix, ClassPath classPath, DataEntryReader reader) throws IOException {
        this.readInput(messagePrefix, classPath, 0, classPath.size(), reader);
    }

    public void readInput(String messagePrefix, ClassPath classPath, int fromIndex, int toIndex, DataEntryReader reader) throws IOException {
        for (int index = fromIndex; index < toIndex; ++index) {
            ClassPathEntry entry = classPath.get(index);
            if (entry.isOutput()) continue;
            this.readInput(messagePrefix, entry, reader);
        }
    }

    private void readInput(String messagePrefix, ClassPathEntry classPathEntry, DataEntryReader dataEntryReader) throws IOException {
        try {
            DataEntryReader reader = DataEntryReaderFactory.createDataEntryReader(messagePrefix, classPathEntry, dataEntryReader);
            DirectoryPump directoryPump = new DirectoryPump(classPathEntry.getFile());
            directoryPump.pumpDataEntries(reader);
        }
        catch (IOException ex) {
            throw (IOException)new IOException("Can't read [" + classPathEntry + "] (" + ex.getMessage() + ")").initCause(ex);
        }
    }
}

