/*
 * Decompiled with CFR 0.152.
 */
package proguard.ant;

import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;
import proguard.MemberSpecification;
import proguard.classfile.util.ClassUtil;
import proguard.util.ListUtil;

public class MemberSpecificationElement
extends DataType {
    private String access;
    private String annotation;
    private String type;
    private String name;
    private String parameters;

    public void appendTo(List memberSpecifications, boolean isMethod, boolean isConstructor) {
        MemberSpecificationElement memberSpecificationElement = this.isReference() ? (MemberSpecificationElement)((Object)this.getCheckedRef(((Object)((Object)this)).getClass(), ((Object)((Object)this)).getClass().getName())) : this;
        String access = memberSpecificationElement.access;
        String type = memberSpecificationElement.type;
        String annotation = memberSpecificationElement.annotation;
        String name = memberSpecificationElement.name;
        String parameters = memberSpecificationElement.parameters;
        if (annotation != null) {
            annotation = ClassUtil.internalType((String)annotation);
        }
        if (isMethod) {
            if (isConstructor) {
                if (type != null) {
                    throw new BuildException("Type attribute not allowed in constructor specification [" + type + "]");
                }
                if (parameters != null) {
                    type = "void";
                }
                name = "<init>";
            } else if (type != null ^ parameters != null) {
                throw new BuildException("Type and parameters attributes must always be present in combination in method specification");
            }
        } else if (parameters != null) {
            throw new BuildException("Parameters attribute not allowed in field specification [" + parameters + "]");
        }
        List parameterList = ListUtil.commaSeparatedList((String)parameters);
        String descriptor = parameters != null ? ClassUtil.internalMethodDescriptor((String)type, (List)parameterList) : (type != null ? ClassUtil.internalType((String)type) : null);
        MemberSpecification memberSpecification = new MemberSpecification(this.requiredAccessFlags(true, access), this.requiredAccessFlags(false, access), annotation, name, descriptor);
        memberSpecifications.add(memberSpecification);
    }

    public void setAccess(String access) {
        this.access = access;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public void setParam(String parameters) {
        this.parameters = parameters;
    }

    private int requiredAccessFlags(boolean set, String access) throws BuildException {
        int accessFlags = 0;
        if (access != null) {
            StringTokenizer tokenizer = new StringTokenizer(access, " ,");
            while (tokenizer.hasMoreTokens()) {
                int accessFlag;
                String strippedToken;
                String token = tokenizer.nextToken();
                if (!(token.startsWith("!") ^ set)) continue;
                String string = strippedToken = token.startsWith("!") ? token.substring(1) : token;
                int n = strippedToken.equals("public") ? 1 : (strippedToken.equals("private") ? 2 : (strippedToken.equals("protected") ? 4 : (strippedToken.equals("static") ? 8 : (strippedToken.equals("final") ? 16 : (strippedToken.equals("synchronized") ? 32 : (strippedToken.equals("volatile") ? 64 : (strippedToken.equals("transient") ? 128 : (strippedToken.equals("bridge") ? 64 : (strippedToken.equals("varargs") ? 128 : (strippedToken.equals("native") ? 256 : (strippedToken.equals("abstract") ? 1024 : (strippedToken.equals("strictfp") ? 2048 : (accessFlag = strippedToken.equals("synthetic") ? 4096 : 0)))))))))))));
                if (accessFlag == 0) {
                    throw new BuildException("Incorrect class member access modifier [" + strippedToken + "]");
                }
                accessFlags |= accessFlag;
            }
        }
        return accessFlags;
    }
}

