/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.util;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.openas2.DispositionException;
import org.openas2.OpenAS2Exception;

public class DispositionType {
    private String action;
    private String mdnAction;
    private String status;
    private String statusDescription;
    private String statusModifier;

    public DispositionType(String action, String mdnAction, String status, String statusModifier, String statusDescription) {
        this.action = action;
        this.mdnAction = mdnAction;
        this.status = status;
        this.statusModifier = statusModifier;
        this.statusDescription = statusDescription;
    }

    public DispositionType(String action, String mdnAction, String status) {
        this.action = action;
        this.mdnAction = mdnAction;
        this.status = status;
        this.statusModifier = null;
        this.statusDescription = null;
    }

    public DispositionType(String disposition) throws OpenAS2Exception {
        if (disposition != null) {
            this.parseDisposition(disposition);
        }
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public void setMdnAction(String mdnAction) {
        this.mdnAction = mdnAction;
    }

    public String getMdnAction() {
        return this.mdnAction;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void setStatusModifier(String statusModifier) {
        this.statusModifier = statusModifier;
    }

    public String getStatusModifier() {
        return this.statusModifier;
    }

    public boolean isWarning() {
        String statusMod = this.getStatusModifier();
        return statusMod != null && statusMod.equalsIgnoreCase("warning");
    }

    public String toString() {
        return this.makeDisposition();
    }

    public void validate() throws DispositionException {
        String status = this.getStatus();
        if (status == null) {
            throw new DispositionException(this, "Disposition status is NULL. Cannot continue.");
        }
        if (!status.equalsIgnoreCase("processed")) {
            throw new DispositionException(this, "Disposition status indicates a problem. Returned status is: " + status);
        }
        String statusMod = this.getStatusModifier();
        if (statusMod != null && (statusMod.equalsIgnoreCase("error") || statusMod.equalsIgnoreCase("warning"))) {
            throw new DispositionException(this, "The recipient is indicating an issue with the received message. Returned status is: " + status);
        }
    }

    protected String makeDisposition() {
        StringBuffer dispBuf = new StringBuffer();
        dispBuf.append(this.getAction()).append("/").append(this.getMdnAction());
        dispBuf.append("; ").append(this.getStatus());
        if (this.getStatusModifier() != null) {
            dispBuf.append("/").append(this.getStatusModifier()).append(":");
            if (this.getStatusDescription() != null) {
                dispBuf.append(this.getStatusDescription());
            }
        }
        return dispBuf.toString();
    }

    protected void parseDisposition(String disposition) throws OpenAS2Exception {
        StringTokenizer dispTokens = new StringTokenizer(disposition, "/;:", false);
        try {
            this.setAction(dispTokens.nextToken().toLowerCase());
            this.setMdnAction(dispTokens.nextToken().toLowerCase());
            this.setStatus(dispTokens.nextToken().trim().toLowerCase());
            this.setStatusModifier(null);
            this.setStatusDescription(null);
            if (dispTokens.hasMoreTokens()) {
                this.setStatusModifier(dispTokens.nextToken().toLowerCase());
                if (dispTokens.hasMoreTokens()) {
                    this.setStatusDescription(dispTokens.nextToken().trim().toLowerCase());
                }
            }
        }
        catch (NoSuchElementException nsee) {
            throw new OpenAS2Exception("Invalid disposition type format: " + disposition);
        }
    }
}

