/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.processor.resender;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.WrappedException;
import org.openas2.message.Message;
import org.openas2.params.InvalidParameterException;
import org.openas2.processor.resender.BaseResenderModule;
import org.openas2.util.AS2Util;
import org.openas2.util.DateUtil;
import org.openas2.util.IOUtilOld;

public class DirectoryResenderModule
extends BaseResenderModule {
    public static final String PARAM_RESEND_DIRECTORY = "resenddir";
    public static final String PARAM_ERROR_DIRECTORY = "errordir";
    public static final String PARAM_RESEND_DELAY = "resenddelay";
    public static final long DEFAULT_RESEND_DELAY = 900000L;
    private Log logger = LogFactory.getLog((String)DirectoryResenderModule.class.getSimpleName());

    @Override
    public boolean canHandle(String action, Message msg, Map<Object, Object> options) {
        return action.equals("resend");
    }

    @Override
    public void handle(String action, Message msg, Map<Object, Object> options) throws OpenAS2Exception {
        ObjectOutputStream oos = null;
        try {
            String retries;
            File resendDir = IOUtilOld.getDirectoryFile(this.getParameter(PARAM_RESEND_DIRECTORY, true));
            File resendFile = IOUtilOld.getUnique(resendDir, this.getFilename());
            oos = new ObjectOutputStream(new FileOutputStream(resendFile));
            String method = (String)options.get("resend_method");
            if (method == null) {
                method = "send";
            }
            if ((retries = (String)options.get("retries")) == null) {
                retries = "-1";
            }
            oos.writeObject(method);
            oos.writeObject(retries);
            oos.writeObject(msg);
            this.logger.info((Object)("message put in resend queue" + msg.getLogMsgID()));
            if (this.logger.isTraceEnabled()) {
                try {
                    this.logger.trace((Object)("Message object in resender module for storage. Content-Disposition: " + msg.getContentDisposition() + "\n      Content-Type : " + msg.getContentType() + "\n      Retries : " + retries + "\n      HEADERS : " + AS2Util.printHeaders(msg.getData().getAllHeaders()) + "\n      Content-Disposition in MSG getData() MIMEPART: " + msg.getData().getContentType() + msg.getLogMsgID()));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        catch (IOException ioe) {
            throw new WrappedException(ioe);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public void init(Session session, Map<String, String> options) throws OpenAS2Exception {
        super.init(session, options);
        this.getParameter(PARAM_RESEND_DIRECTORY, true);
        this.getParameter(PARAM_ERROR_DIRECTORY, true);
    }

    @Override
    public void resend() {
        try {
            try {
                List<File> sendFiles = this.scanDirectory();
                for (File currentFile : sendFiles) {
                    this.processFile(currentFile);
                }
            }
            catch (IOException ioe) {
                throw new WrappedException(ioe);
            }
        }
        catch (OpenAS2Exception oae) {
            oae.terminate();
            this.forceStop(oae);
        }
    }

    protected String getFilename() throws InvalidParameterException {
        long resendDelay = this.getParameter(PARAM_RESEND_DELAY, false) == null ? 900000L : (long)(this.getParameterInt(PARAM_RESEND_DELAY, false) * 1000);
        long resendTime = new Date().getTime() + resendDelay;
        return DateUtil.formatDate("MM-dd-yy-HH-mm-ss", new Date(resendTime));
    }

    protected boolean isTimeToSend(File currentFile) {
        try {
            StringTokenizer fileTokens = new StringTokenizer(currentFile.getName(), ".", false);
            Date timestamp = DateUtil.parseDate("MM-dd-yy-HH-mm-ss", fileTokens.nextToken());
            return timestamp.before(new Date());
        }
        catch (Exception e) {
            return true;
        }
    }

    protected void processFile(File file) throws OpenAS2Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("processing " + file.getAbsolutePath()));
        }
        Message msg = null;
        try {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
                String method = (String)ois.readObject();
                String retries = (String)ois.readObject();
                msg = (Message)ois.readObject();
                ois.close();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("loaded message for resend." + msg.getLogMsgID()));
                }
                if (this.logger.isTraceEnabled()) {
                    try {
                        this.logger.trace((Object)("Reconstituted Message object in resender. Content-Disposition: " + msg.getContentDisposition() + "\n      Content-Type : " + msg.getContentType() + "\n      HEADERS : " + AS2Util.printHeaders(msg.getData().getAllHeaders()) + "\n      Content-Disposition in MSG getData() MIMEPART: " + msg.getData().getContentType() + msg.getLogMsgID()));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                msg.setOption("retries", retries);
                msg.setStatus("resending_msg");
                this.getSession().getProcessor().handle(method, msg, msg.getOptions());
                if (!file.delete()) {
                    throw new OpenAS2Exception("File was successfully sent but not deleted: " + file.getAbsolutePath());
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("deleted " + file.getAbsolutePath() + msg.getLogMsgID()));
                }
            }
            catch (IOException ioe) {
                throw new WrappedException(ioe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new WrappedException(cnfe);
            }
        }
        catch (OpenAS2Exception oae) {
            oae.addSource("message", msg);
            oae.addSource("file", file);
            oae.terminate();
            IOUtilOld.handleError(file, this.getParameter(PARAM_ERROR_DIRECTORY, true));
        }
    }

    protected List<File> scanDirectory() throws OpenAS2Exception, IOException {
        File resendDir = IOUtilOld.getDirectoryFile(this.getParameter(PARAM_RESEND_DIRECTORY, true));
        ArrayList<File> sendFiles = new ArrayList<File>();
        File[] files = resendDir.listFiles();
        if (files == null) {
            throw new InvalidParameterException("Error getting list of files in directory", this, PARAM_RESEND_DIRECTORY, resendDir.getAbsolutePath());
        }
        if (files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                File currentFile = files[i];
                if (!currentFile.exists() || !currentFile.isFile() || !currentFile.canWrite() || !this.isTimeToSend(currentFile)) continue;
                sendFiles.add(currentFile);
            }
        }
        return sendFiles;
    }
}

