/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.processor.receiver;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import javax.mail.internet.InternetHeaders;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openas2.processor.receiver.HealthCheckModule;
import org.openas2.processor.receiver.NetModule;
import org.openas2.processor.receiver.NetModuleHandler;
import org.openas2.util.HTTPUtil;

public class HealthCheckHandler
implements NetModuleHandler {
    private HealthCheckModule module;
    private Log logger = LogFactory.getLog((String)HealthCheckHandler.class.getSimpleName());

    public HealthCheckHandler(HealthCheckModule module) {
        this.module = module;
    }

    public String getClientInfo(Socket s) {
        return " " + s.getInetAddress().getHostAddress() + " " + Integer.toString(s.getPort());
    }

    public HealthCheckModule getModule() {
        return this.module;
    }

    @Override
    public void handle(NetModule owner, Socket s) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Healthcheck connection:  [" + this.getClientInfo(s) + "]"));
        }
        byte[] data = null;
        try {
            InternetHeaders headers = new InternetHeaders();
            ArrayList<String> request = new ArrayList<String>(2);
            data = HTTPUtil.readHTTP(s.getInputStream(), s.getOutputStream(), headers, request);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("HealthCheck received request: " + ((Object)request).toString() + "\n\tHeaders: " + headers + "\n\tData: " + data));
            }
            HTTPUtil.sendHTTPResponse(s.getOutputStream(), 200, false);
        }
        catch (Exception e) {
            try {
                HTTPUtil.sendHTTPResponse(s.getOutputStream(), 503, false);
            }
            catch (IOException e1) {
                // empty catch block
            }
            String msg = "Unhandled error condition receiving healthcheck.";
            this.logger.error((Object)msg, (Throwable)e);
            return;
        }
    }
}

