/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.message;

import org.openas2.message.BaseMessage;
import org.openas2.message.Message;
import org.openas2.params.InvalidParameterException;
import org.openas2.partner.Partnership;
import org.openas2.util.AS2Util;

public class AS2Message
extends BaseMessage
implements Message {
    private static final long serialVersionUID = 1L;
    public static final String PROTOCOL_AS2 = "as2";

    @Override
    public String getProtocol() {
        return PROTOCOL_AS2;
    }

    @Override
    public String generateMessageID() throws InvalidParameterException {
        return AS2Util.generateMessageID(this);
    }

    @Override
    public boolean isRequestingMDN() {
        return this.getHeader("Disposition-Notification-To") != null || this.getHeader("Disposition-Notification-Options") != null;
    }

    @Override
    public boolean isConfiguredForMDN() {
        Partnership p = this.getPartnership();
        return p.getAttribute("as2_mdn_to") != null && p.getAttribute("as2_mdn_options") != null;
    }

    @Override
    public boolean isRequestingAsynchMDN() {
        return this.getHeader("Receipt-Delivery-Option") != null;
    }

    @Override
    public boolean isConfiguredForAsynchMDN() {
        Partnership p = this.getPartnership();
        return p.getAttribute("as2_receipt_option") != null;
    }

    public String getAsyncMDNurl() {
        return this.getHeader("Receipt-Delivery-Option");
    }
}

