/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.lib.util;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.openas2.lib.util.GeneralUtil;

public class XMLUtil {
    public static Document getDocument(InputStream in) throws DocumentException {
        SAXReader reader = new SAXReader();
        return reader.read(in);
    }

    public static Document getDocument(String xml) throws DocumentException {
        SAXReader reader = new SAXReader();
        return reader.read((Reader)new StringReader(xml));
    }

    public static void requireElement(Element element, String name) throws DocumentException {
        if (!element.getName().equalsIgnoreCase(name)) {
            throw new DocumentException("Missing required element: " + name);
        }
    }

    public static Element requireChildElement(Element parent, String name) throws DocumentException {
        Element child = parent.element(name);
        if (child == null) {
            throw new DocumentException("Missing required element: " + name);
        }
        return child;
    }

    public static String[] getChildNames(Element parent) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        Iterator it = parent.elementIterator();
        while (it.hasNext()) {
            Element child = (Element)it.next();
            parameterNames.add(child.getName());
        }
        return GeneralUtil.convert(parameterNames);
    }

    public static Map<String, String> mapAttributes(Element element) {
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        Iterator it = element.attributeIterator();
        while (it.hasNext()) {
            Attribute attribute = (Attribute)it.next();
            attributeMap.put(attribute.getName(), attribute.getStringValue());
        }
        return attributeMap;
    }

    public static Map<String, String> mapAttributes(Element element, String[] ignore) {
        Map<String, String> attributeMap = XMLUtil.mapAttributes(element);
        for (int i = 0; i < ignore.length; ++i) {
            attributeMap.remove(ignore[i]);
        }
        return attributeMap;
    }

    public static Map<String, String> mapChildValues(Element parent) {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        Iterator it = parent.elementIterator();
        while (it.hasNext()) {
            Element child = (Element)it.next();
            valueMap.put(child.getName(), child.getStringValue());
        }
        return valueMap;
    }

    public static void convertMap(Element parent, Map<Object, Object> values) {
        for (Map.Entry<Object, Object> entry : values.entrySet()) {
            Element child = parent.addElement(entry.getKey().toString());
            child.setText(entry.getValue().toString());
        }
    }

    public static void removeElements(Element parent, String name) {
        Iterator it = parent.elementIterator(name);
        while (it.hasNext()) {
            Element el = (Element)it.next();
            parent.remove(el);
        }
    }
}

