/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.lib.partner;

import java.util.HashMap;
import java.util.Map;
import org.openas2.lib.partner.BasicPartner;
import org.openas2.lib.partner.BasicPartnership;
import org.openas2.lib.partner.IPartner;
import org.openas2.lib.partner.IPartnerStore;
import org.openas2.lib.partner.IPartnership;
import org.openas2.lib.util.GeneralUtil;

public class BasicPartnerStore
implements IPartnerStore {
    private Map<String, Object> partners;
    private Map<String, Object> partnerships;

    @Override
    public IPartner createPartner() {
        return new BasicPartner();
    }

    @Override
    public IPartnership createPartnership() {
        return new BasicPartnership();
    }

    @Override
    public String[] getPartners() {
        return GeneralUtil.convertKeys(this.getPartnersMap());
    }

    @Override
    public IPartner getPartner(String alias) {
        return (IPartner)this.getPartnersMap().get(alias);
    }

    @Override
    public void setPartner(String alias, IPartner partner) {
        this.getPartnersMap().put(alias, partner);
    }

    @Override
    public String getAlias(IPartner partner) {
        return (String)GeneralUtil.getKey(this.getPartnersMap(), partner);
    }

    @Override
    public void removePartner(String alias) {
        this.getPartnersMap().remove(alias);
    }

    @Override
    public String[] getPartnerships() {
        return GeneralUtil.convertKeys(this.getPartnershipsMap());
    }

    @Override
    public IPartnership getPartnership(String alias) {
        return (IPartnership)this.getPartnershipsMap().get(alias);
    }

    @Override
    public void setPartnership(String alias, IPartnership partnership) {
        this.getPartnershipsMap().put(alias, partnership);
    }

    @Override
    public String getAlias(IPartnership partnership) {
        return (String)GeneralUtil.getKey(this.getPartnershipsMap(), partnership);
    }

    @Override
    public void removePartnership(String alias) {
        this.getPartnershipsMap().remove(alias);
    }

    protected Map<String, Object> getPartnersMap() {
        if (this.partners == null) {
            this.partners = new HashMap<String, Object>();
        }
        return this.partners;
    }

    protected Map<String, Object> getPartnershipsMap() {
        if (this.partnerships == null) {
            this.partnerships = new HashMap<String, Object>();
        }
        return this.partnerships;
    }
}

